/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase2_x;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.cloud.bigtable.hbase.AbstractBigtableRegionLocator;
import com.google.cloud.bigtable.hbase.adapters.SampledRowKeysAdapter;
import com.google.cloud.bigtable.hbase.wrappers.BigtableHBaseSettings;
import com.google.cloud.bigtable.hbase.wrappers.DataClientWrapper;
import com.google.cloud.bigtable.hbase2_x.ApiFutureUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi(value="For internal usage only")
public class BigtableAsyncTableRegionLocator
extends AbstractBigtableRegionLocator
implements AsyncTableRegionLocator {
    public BigtableAsyncTableRegionLocator(TableName tableName, BigtableHBaseSettings settings, DataClientWrapper client) {
        super(tableName, settings, client);
    }

    public TableName getName() {
        return this.tableName;
    }

    public CompletableFuture<HRegionLocation> getRegionLocation(byte[] row, boolean reload) {
        return ApiFutureUtils.toCompletableFuture(this.getRegionsAsync(reload)).thenApplyAsync(result -> this.findRegion((List<HRegionLocation>)result, row));
    }

    private HRegionLocation findRegion(List<HRegionLocation> regions, byte[] row) {
        int low = 0;
        int high = regions.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            HRegionLocation regionLocation = regions.get(mid);
            HRegionInfo regionInfo = regionLocation.getRegionInfo();
            if (regionInfo.getEndKey().length > 0 && Bytes.compareTo((byte[])row, (byte[])regionInfo.getEndKey()) >= 0) {
                low = mid + 1;
                continue;
            }
            if (Bytes.compareTo((byte[])row, (byte[])regionInfo.getStartKey()) < 0) {
                high = mid - 1;
                continue;
            }
            return regionLocation;
        }
        return null;
    }

    public CompletableFuture<HRegionLocation> getRegionLocation(byte[] row, int replicaId, boolean reload) {
        return this.getRegionLocation(row, reload);
    }

    public CompletableFuture<List<HRegionLocation>> getRegionLocations(byte[] row, boolean reload) {
        throw new UnsupportedOperationException("getRegionLocations");
    }

    public CompletableFuture<List<HRegionLocation>> getAllRegionLocations() {
        throw new UnsupportedOperationException("getAllRegionLocations");
    }

    public void clearRegionLocationCache() {
        throw new UnsupportedOperationException("clearRegionLocationCache");
    }

    @Override
    public SampledRowKeysAdapter getSampledRowKeysAdapter(TableName tableName, ServerName serverName) {
        return new SampledRowKeysAdapter(tableName, serverName){

            @Override
            protected HRegionLocation createRegionLocation(byte[] startKey, byte[] endKey) {
                RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)this.tableName).setStartKey(startKey).setEndKey(endKey).build();
                return new HRegionLocation(regionInfo, this.serverName);
            }
        };
    }
}

