/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase2_x;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.cloud.bigtable.hbase.adapters.SampledRowKeysAdapter;
import com.google.cloud.bigtable.hbase2_x.BigtableAdmin;
import com.google.cloud.bigtable.hbase2_x.BigtableTable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractBigtableConnection;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Hbck;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.security.User;

@InternalApi(value="For internal usage only")
public class BigtableConnection
extends AbstractBigtableConnection {
    public BigtableConnection(Configuration conf) throws IOException {
        super(conf);
    }

    public BigtableConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        super(conf);
    }

    @Override
    protected SampledRowKeysAdapter createSampledRowKeysAdapter(TableName tableName, ServerName serverName) {
        return new SampledRowKeysAdapter(tableName, serverName){

            @Override
            protected HRegionLocation createRegionLocation(byte[] startKey, byte[] endKey) {
                RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)this.tableName).setStartKey(startKey).setEndKey(endKey).build();
                return new HRegionLocation(regionInfo, this.serverName);
            }
        };
    }

    @Override
    public Admin getAdmin() throws IOException {
        return BigtableAdmin.createInstance(this);
    }

    public TableBuilder getTableBuilder(final TableName tableName, final ExecutorService pool) {
        return new TableBuilder(){

            public TableBuilder setWriteRpcTimeout(int arg0) {
                return this;
            }

            public TableBuilder setRpcTimeout(int arg0) {
                return this;
            }

            public TableBuilder setReadRpcTimeout(int arg0) {
                return this;
            }

            public TableBuilder setOperationTimeout(int arg0) {
                return this;
            }

            public Table build() {
                try {
                    return BigtableConnection.this.getTable(tableName, pool);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not create the table", e);
                }
            }
        };
    }

    public Table getTable(TableName tableName, ExecutorService ignored) throws IOException {
        return new BigtableTable(this, this.createAdapter(tableName));
    }

    public void clearRegionLocationCache() {
        throw new UnsupportedOperationException("clearRegionLocationCache");
    }

    @Override
    public List<HRegionInfo> getAllRegionInfos(TableName tableName) throws IOException {
        CopyOnWriteArrayList<HRegionInfo> regionInfos = new CopyOnWriteArrayList<HRegionInfo>();
        for (HRegionLocation location : this.getRegionLocator(tableName).getAllRegionLocations()) {
            regionInfos.add(location.getRegionInfo());
        }
        return regionInfos;
    }

    public Hbck getHbck() throws IOException {
        return this.createUnsupportedProxy(Hbck.class);
    }

    public Hbck getHbck(ServerName masterServer) throws IOException {
        return this.createUnsupportedProxy(Hbck.class);
    }

    private <T> T createUnsupportedProxy(Class<T> cls) {
        Object proxy = Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, (InvocationHandler)new UnsupportedInvocationHandler("Unsupported" + cls.getSimpleName()));
        return (T)proxy;
    }

    private static class UnsupportedInvocationHandler
    implements InvocationHandler {
        private final String name;

        private UnsupportedInvocationHandler(String name) {
            this.name = name;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            int argCount;
            int n = argCount = args == null ? 0 : args.length;
            if (argCount == 1 && method.getName().equals("equals") && method.getParameterTypes()[0] == Object.class) {
                Object arg = args[0];
                if (arg == null) {
                    return false;
                }
                return proxy == arg;
            }
            if (argCount == 0 && method.getName().equals("hashCode")) {
                return super.hashCode();
            }
            if (argCount == 0 && method.getName().equals("toString")) {
                return this.name;
            }
            throw new UnsupportedOperationException(this.name + "." + method.getName());
        }
    }
}

