/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase2_x;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.bigtable.hbase.AbstractBigtableTable;
import com.google.cloud.bigtable.hbase.adapters.CheckAndMutateUtil;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import com.google.cloud.bigtable.hbase.util.FutureUtil;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.client.AbstractBigtableConnection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.TimeRange;

@InternalApi(value="For internal usage only")
public class BigtableTable
extends AbstractBigtableTable {
    public static final CompareFilter.CompareOp toCompareOp(CompareOperator compareOp) {
        switch (compareOp) {
            case EQUAL: {
                return CompareFilter.CompareOp.EQUAL;
            }
            case GREATER: {
                return CompareFilter.CompareOp.GREATER;
            }
            case GREATER_OR_EQUAL: {
                return CompareFilter.CompareOp.GREATER_OR_EQUAL;
            }
            case LESS: {
                return CompareFilter.CompareOp.LESS;
            }
            case LESS_OR_EQUAL: {
                return CompareFilter.CompareOp.LESS_OR_EQUAL;
            }
            case NO_OP: {
                return CompareFilter.CompareOp.NO_OP;
            }
            case NOT_EQUAL: {
                return CompareFilter.CompareOp.NOT_EQUAL;
            }
        }
        throw new IllegalArgumentException("CompareOp type: " + compareOp + " cannot be converted");
    }

    public BigtableTable(AbstractBigtableConnection bigtableConnection, HBaseRequestAdapter hbaseAdapter) {
        super(bigtableConnection, hbaseAdapter);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, byte[] value, Delete delete) throws IOException {
        return super.checkAndDelete(row, family, qualifier, BigtableTable.toCompareOp(compareOp), value, delete);
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, byte[] value, RowMutations rm) throws IOException {
        return super.checkAndMutate(row, family, qualifier, BigtableTable.toCompareOp(compareOp), value, rm);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, byte[] value, Put put) throws IOException {
        return super.checkAndPut(row, family, qualifier, BigtableTable.toCompareOp(compareOp), value, put);
    }

    public boolean[] exists(List<Get> gets) throws IOException {
        return this.existsAll(gets);
    }

    public TableDescriptor getDescriptor() throws IOException {
        return super.getTableDescriptor();
    }

    public RegionLocator getRegionLocator() throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    public long getOperationTimeout(TimeUnit arg0) {
        return 0L;
    }

    @Override
    public int getReadRpcTimeout() {
        return 0;
    }

    public long getReadRpcTimeout(TimeUnit arg0) {
        return 0L;
    }

    public long getRpcTimeout(TimeUnit arg0) {
        return 0L;
    }

    @Override
    public int getWriteRpcTimeout() {
        return 0;
    }

    public long getWriteRpcTimeout(TimeUnit arg0) {
        return 0L;
    }

    @Override
    public void setReadRpcTimeout(int arg0) {
    }

    @Override
    public void setWriteRpcTimeout(int arg0) {
    }

    public Table.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        final CheckAndMutateUtil.RequestBuilder builder = new CheckAndMutateUtil.RequestBuilder(this.hbaseAdapter, row, family);
        return new Table.CheckAndMutateBuilder(){

            public Table.CheckAndMutateBuilder qualifier(byte[] qualifier) {
                builder.qualifier(qualifier);
                return this;
            }

            public Table.CheckAndMutateBuilder ifNotExists() {
                builder.ifNotExists();
                return this;
            }

            public Table.CheckAndMutateBuilder ifMatches(CompareOperator compareOp, byte[] value) {
                Preconditions.checkNotNull(compareOp, "compareOp is null");
                if (compareOp != CompareOperator.NOT_EQUAL) {
                    Preconditions.checkNotNull(value, "value is null for compareOperator: " + compareOp);
                }
                builder.ifMatches(BigtableTable.toCompareOp(compareOp), value);
                return this;
            }

            public Table.CheckAndMutateBuilder timeRange(TimeRange timeRange) {
                builder.timeRange(timeRange.getMin(), timeRange.getMax());
                return this;
            }

            public boolean thenPut(Put put) throws IOException {
                try {
                    builder.withPut(put);
                    return this.call();
                }
                catch (Exception e) {
                    throw new IOException("Could not CheckAndMutate.thenPut: " + e.getMessage(), e);
                }
            }

            public boolean thenDelete(Delete delete) throws IOException {
                try {
                    builder.withDelete(delete);
                    return this.call();
                }
                catch (Exception e) {
                    throw new IOException("Could not CheckAndMutate.thenDelete: " + e.getMessage(), e);
                }
            }

            public boolean thenMutate(RowMutations rowMutations) throws IOException {
                try {
                    builder.withMutations(rowMutations);
                    return this.call();
                }
                catch (Exception e) {
                    throw new IOException("Could not CheckAndMutate.thenMutate: " + e.getMessage(), e);
                }
            }

            private boolean call() throws IOException {
                ConditionalRowMutation conditionalRowMutation = builder.build();
                Boolean response = FutureUtil.unwrap(BigtableTable.this.clientWrapper.checkAndMutateRowAsync(conditionalRowMutation));
                return CheckAndMutateUtil.wasMutationApplied(conditionalRowMutation, response);
            }
        };
    }

    @Override
    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        if (actions.isEmpty()) {
            return;
        }
        super.batchCallback(actions, results, callback);
    }
}

