/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Row;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.RowMerger;
import java.util.ArrayList;
import java.util.List;

@InternalApi(value="For internal google use only")
public class RowMergerUtil
implements AutoCloseable {
    private final RowMerger<Row> merger;

    public RowMergerUtil() {
        RowAdapter.RowBuilder<Row> rowBuilder = new DefaultRowAdapter().createRowBuilder();
        this.merger = new RowMerger<Row>(rowBuilder);
    }

    @Override
    public void close() {
        if (this.merger.hasPartialFrame()) {
            throw new IllegalStateException("Tried to close merger with unmerged partial data");
        }
    }

    public List<Row> parseReadRowsResponses(Iterable<ReadRowsResponse> responses) {
        ArrayList<Row> rows = new ArrayList<Row>();
        for (ReadRowsResponse response : responses) {
            this.merger.push(response);
            while (this.merger.hasFullFrame()) {
                rows.add(this.merger.pop());
            }
        }
        return rows;
    }
}

