/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.ClientStreamTracer;
import com.google.bigtable.repackaged.io.grpc.ConnectivityState;
import com.google.bigtable.repackaged.io.grpc.EquivalentAddressGroup;
import com.google.bigtable.repackaged.io.grpc.InternalLogId;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.ForwardingClientStreamTracer;
import com.google.bigtable.repackaged.io.grpc.internal.ObjectPool;
import com.google.bigtable.repackaged.io.grpc.util.ForwardingLoadBalancerHelper;
import com.google.bigtable.repackaged.io.grpc.util.ForwardingSubchannel;
import com.google.bigtable.repackaged.io.grpc.xds.Bootstrapper;
import com.google.bigtable.repackaged.io.grpc.xds.ClusterImplLoadBalancerProvider;
import com.google.bigtable.repackaged.io.grpc.xds.Endpoints;
import com.google.bigtable.repackaged.io.grpc.xds.EnvoyServerProtoData;
import com.google.bigtable.repackaged.io.grpc.xds.InternalXdsAttributes;
import com.google.bigtable.repackaged.io.grpc.xds.LoadStatsManager2;
import com.google.bigtable.repackaged.io.grpc.xds.Locality;
import com.google.bigtable.repackaged.io.grpc.xds.ThreadSafeRandom;
import com.google.bigtable.repackaged.io.grpc.xds.XdsClient;
import com.google.bigtable.repackaged.io.grpc.xds.XdsLogger;
import com.google.bigtable.repackaged.io.grpc.xds.XdsNameResolverProvider;
import com.google.bigtable.repackaged.io.grpc.xds.XdsSubchannelPickers;
import com.google.bigtable.repackaged.io.grpc.xds.internal.security.SslContextProviderSupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

final class ClusterImplLoadBalancer
extends LoadBalancer {
    @VisibleForTesting
    static final long DEFAULT_PER_CLUSTER_MAX_CONCURRENT_REQUESTS = 1024L;
    @VisibleForTesting
    static boolean enableCircuitBreaking = Strings.isNullOrEmpty(System.getenv("GRPC_XDS_EXPERIMENTAL_CIRCUIT_BREAKING")) || Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_CIRCUIT_BREAKING"));
    @VisibleForTesting
    static boolean enableSecurity = Strings.isNullOrEmpty(System.getenv("GRPC_XDS_EXPERIMENTAL_SECURITY_SUPPORT")) || Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_SECURITY_SUPPORT"));
    private static final Attributes.Key<LoadStatsManager2.ClusterLocalityStats> ATTR_CLUSTER_LOCALITY_STATS = Attributes.Key.create("com.google.bigtable.repackaged.io.grpc.xds.ClusterImplLoadBalancer.clusterLocalityStats");
    private final XdsLogger logger;
    private final LoadBalancer.Helper helper;
    private final ThreadSafeRandom random;
    private String cluster;
    @Nullable
    private String edsServiceName;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private XdsNameResolverProvider.CallCounterProvider callCounterProvider;
    private LoadStatsManager2.ClusterDropStats dropStats;
    private ClusterImplLbHelper childLbHelper;
    private LoadBalancer childLb;

    ClusterImplLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, ThreadSafeRandom.ThreadSafeRandomImpl.instance);
    }

    ClusterImplLoadBalancer(LoadBalancer.Helper helper, ThreadSafeRandom random) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.random = Preconditions.checkNotNull(random, "random");
        InternalLogId logId = InternalLogId.allocate("cluster-impl-lb", helper.getAuthority());
        this.logger = XdsLogger.withLogId(logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    @Override
    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        Attributes attributes = resolvedAddresses.getAttributes();
        if (this.xdsClientPool == null) {
            this.xdsClientPool = attributes.get(InternalXdsAttributes.XDS_CLIENT_POOL);
            this.xdsClient = this.xdsClientPool.getObject();
        }
        if (this.callCounterProvider == null) {
            this.callCounterProvider = attributes.get(InternalXdsAttributes.CALL_COUNTER_PROVIDER);
        }
        ClusterImplLoadBalancerProvider.ClusterImplConfig config = (ClusterImplLoadBalancerProvider.ClusterImplConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        if (this.cluster == null) {
            this.cluster = config.cluster;
            this.edsServiceName = config.edsServiceName;
            this.childLbHelper = new ClusterImplLbHelper(this.callCounterProvider.getOrCreate(config.cluster, config.edsServiceName), config.lrsServerInfo);
            this.childLb = config.childPolicy.getProvider().newLoadBalancer(this.childLbHelper);
            if (config.lrsServerInfo != null) {
                this.dropStats = this.xdsClient.addClusterDropStats(config.lrsServerInfo, this.cluster, this.edsServiceName);
            }
        }
        this.childLbHelper.updateDropPolicies(config.dropCategories);
        this.childLbHelper.updateMaxConcurrentRequests(config.maxConcurrentRequests);
        this.childLbHelper.updateSslContextProviderSupplier(config.tlsContext);
        this.childLb.handleResolvedAddresses(resolvedAddresses.toBuilder().setAttributes(attributes).setLoadBalancingPolicyConfig(config.childPolicy.getConfig()).build());
    }

    @Override
    public void handleNameResolutionError(Status error) {
        if (this.childLb != null) {
            this.childLb.handleNameResolutionError(error);
        } else {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new XdsSubchannelPickers.ErrorPicker(error));
        }
    }

    @Override
    public void shutdown() {
        if (this.dropStats != null) {
            this.dropStats.release();
        }
        if (this.childLb != null) {
            this.childLb.shutdown();
            if (this.childLbHelper != null) {
                this.childLbHelper.updateSslContextProviderSupplier(null);
                this.childLbHelper = null;
            }
        }
        if (this.xdsClient != null) {
            this.xdsClient = this.xdsClientPool.returnObject(this.xdsClient);
        }
    }

    @Override
    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    private static final class CountingStreamTracerFactory
    extends ClientStreamTracer.Factory {
        private LoadStatsManager2.ClusterLocalityStats stats;
        private final AtomicLong inFlights;
        @Nullable
        private final ClientStreamTracer.Factory delegate;

        private CountingStreamTracerFactory(LoadStatsManager2.ClusterLocalityStats stats, AtomicLong inFlights, @Nullable ClientStreamTracer.Factory delegate) {
            this.stats = Preconditions.checkNotNull(stats, "stats");
            this.inFlights = Preconditions.checkNotNull(inFlights, "inFlights");
            this.delegate = delegate;
        }

        @Override
        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            this.stats.recordCallStarted();
            this.inFlights.incrementAndGet();
            if (this.delegate == null) {
                return new ClientStreamTracer(){

                    @Override
                    public void streamClosed(Status status) {
                        stats.recordCallFinished(status);
                        inFlights.decrementAndGet();
                    }
                };
            }
            final ClientStreamTracer delegatedTracer = this.delegate.newClientStreamTracer(info, headers);
            return new ForwardingClientStreamTracer(){

                @Override
                protected ClientStreamTracer delegate() {
                    return delegatedTracer;
                }

                @Override
                public void streamClosed(Status status) {
                    stats.recordCallFinished(status);
                    inFlights.decrementAndGet();
                    this.delegate().streamClosed(status);
                }
            };
        }
    }

    private final class ClusterImplLbHelper
    extends ForwardingLoadBalancerHelper {
        private final AtomicLong inFlights;
        private ConnectivityState currentState = ConnectivityState.IDLE;
        private LoadBalancer.SubchannelPicker currentPicker = XdsSubchannelPickers.BUFFER_PICKER;
        private List<Endpoints.DropOverload> dropPolicies = Collections.emptyList();
        private long maxConcurrentRequests = 1024L;
        @Nullable
        private SslContextProviderSupplier sslContextProviderSupplier;
        @Nullable
        private final Bootstrapper.ServerInfo lrsServerInfo;

        private ClusterImplLbHelper(@Nullable AtomicLong inFlights, Bootstrapper.ServerInfo lrsServerInfo) {
            this.inFlights = Preconditions.checkNotNull(inFlights, "inFlights");
            this.lrsServerInfo = lrsServerInfo;
        }

        @Override
        public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
            this.currentState = newState;
            this.currentPicker = newPicker;
            RequestLimitingSubchannelPicker picker = new RequestLimitingSubchannelPicker(newPicker, this.dropPolicies, this.maxConcurrentRequests);
            this.delegate().updateBalancingState(newState, picker);
        }

        @Override
        public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
            ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
            for (EquivalentAddressGroup eag : args.getAddresses()) {
                Attributes.Builder attrBuilder = eag.getAttributes().toBuilder().set(InternalXdsAttributes.ATTR_CLUSTER_NAME, ClusterImplLoadBalancer.this.cluster);
                if (enableSecurity && this.sslContextProviderSupplier != null) {
                    attrBuilder.set(InternalXdsAttributes.ATTR_SSL_CONTEXT_PROVIDER_SUPPLIER, this.sslContextProviderSupplier);
                }
                addresses.add(new EquivalentAddressGroup(eag.getAddresses(), attrBuilder.build()));
            }
            Locality locality = args.getAddresses().get(0).getAttributes().get(InternalXdsAttributes.ATTR_LOCALITY);
            if (locality == null) {
                locality = Locality.create("", "", "");
            }
            final LoadStatsManager2.ClusterLocalityStats localityStats = this.lrsServerInfo == null ? null : ClusterImplLoadBalancer.this.xdsClient.addClusterLocalityStats(this.lrsServerInfo, ClusterImplLoadBalancer.this.cluster, ClusterImplLoadBalancer.this.edsServiceName, locality);
            Attributes attrs = args.getAttributes().toBuilder().set(ATTR_CLUSTER_LOCALITY_STATS, localityStats).build();
            args = args.toBuilder().setAddresses(addresses).setAttributes(attrs).build();
            final LoadBalancer.Subchannel subchannel = this.delegate().createSubchannel(args);
            return new ForwardingSubchannel(){

                @Override
                public void shutdown() {
                    if (localityStats != null) {
                        localityStats.release();
                    }
                    this.delegate().shutdown();
                }

                @Override
                protected LoadBalancer.Subchannel delegate() {
                    return subchannel;
                }
            };
        }

        @Override
        protected LoadBalancer.Helper delegate() {
            return ClusterImplLoadBalancer.this.helper;
        }

        private void updateDropPolicies(List<Endpoints.DropOverload> dropOverloads) {
            if (!this.dropPolicies.equals(dropOverloads)) {
                this.dropPolicies = dropOverloads;
                this.updateBalancingState(this.currentState, this.currentPicker);
            }
        }

        private void updateMaxConcurrentRequests(@Nullable Long maxConcurrentRequests) {
            if (Objects.equals(this.maxConcurrentRequests, maxConcurrentRequests)) {
                return;
            }
            this.maxConcurrentRequests = maxConcurrentRequests != null ? maxConcurrentRequests : 1024L;
            this.updateBalancingState(this.currentState, this.currentPicker);
        }

        private void updateSslContextProviderSupplier(@Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext) {
            EnvoyServerProtoData.UpstreamTlsContext currentTlsContext;
            EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext = currentTlsContext = this.sslContextProviderSupplier != null ? (EnvoyServerProtoData.UpstreamTlsContext)this.sslContextProviderSupplier.getTlsContext() : null;
            if (Objects.equals(currentTlsContext, tlsContext)) {
                return;
            }
            if (this.sslContextProviderSupplier != null) {
                this.sslContextProviderSupplier.close();
            }
            this.sslContextProviderSupplier = tlsContext != null ? new SslContextProviderSupplier(tlsContext, ClusterImplLoadBalancer.this.xdsClient.getTlsContextManager()) : null;
        }

        private class RequestLimitingSubchannelPicker
        extends LoadBalancer.SubchannelPicker {
            private final LoadBalancer.SubchannelPicker delegate;
            private final List<Endpoints.DropOverload> dropPolicies;
            private final long maxConcurrentRequests;

            private RequestLimitingSubchannelPicker(LoadBalancer.SubchannelPicker delegate, List<Endpoints.DropOverload> dropPolicies, long maxConcurrentRequests) {
                this.delegate = delegate;
                this.dropPolicies = dropPolicies;
                this.maxConcurrentRequests = maxConcurrentRequests;
            }

            @Override
            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                for (Endpoints.DropOverload dropOverload : this.dropPolicies) {
                    int rand = ClusterImplLoadBalancer.this.random.nextInt(1000000);
                    if (rand >= dropOverload.dropsPerMillion()) continue;
                    ClusterImplLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Drop request with category: {0}", dropOverload.category());
                    if (ClusterImplLoadBalancer.this.dropStats != null) {
                        ClusterImplLoadBalancer.this.dropStats.recordDroppedRequest(dropOverload.category());
                    }
                    return LoadBalancer.PickResult.withDrop(Status.UNAVAILABLE.withDescription("Dropped: " + dropOverload.category()));
                }
                LoadBalancer.PickResult result = this.delegate.pickSubchannel(args);
                if (result.getStatus().isOk() && result.getSubchannel() != null) {
                    if (enableCircuitBreaking && ClusterImplLbHelper.this.inFlights.get() >= this.maxConcurrentRequests) {
                        if (ClusterImplLoadBalancer.this.dropStats != null) {
                            ClusterImplLoadBalancer.this.dropStats.recordDroppedRequest();
                        }
                        return LoadBalancer.PickResult.withDrop(Status.UNAVAILABLE.withDescription("Cluster max concurrent requests limit exceeded"));
                    }
                    LoadStatsManager2.ClusterLocalityStats stats = (LoadStatsManager2.ClusterLocalityStats)result.getSubchannel().getAttributes().get(ATTR_CLUSTER_LOCALITY_STATS);
                    if (stats != null) {
                        CountingStreamTracerFactory tracerFactory = new CountingStreamTracerFactory(stats, ClusterImplLbHelper.this.inFlights, result.getStreamTracerFactory());
                        return LoadBalancer.PickResult.withSubchannel(result.getSubchannel(), tracerFactory);
                    }
                }
                return result;
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("delegate", this.delegate).toString();
            }
        }
    }
}

