/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase2_x;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.cloud.bigtable.hbase.BigtableBufferedMutatorHelper;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import com.google.cloud.bigtable.hbase.wrappers.BigtableApi;
import com.google.cloud.bigtable.hbase.wrappers.BigtableHBaseSettings;
import com.google.cloud.bigtable.hbase2_x.ApiFutureUtils;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncBufferedMutator;
import org.apache.hadoop.hbase.client.Mutation;

@InternalApi(value="For internal usage only")
public class BigtableAsyncBufferedMutator
implements AsyncBufferedMutator {
    private final BigtableBufferedMutatorHelper helper;

    public BigtableAsyncBufferedMutator(BigtableApi bigtableApi, BigtableHBaseSettings settings, HBaseRequestAdapter adapter) {
        this.helper = new BigtableBufferedMutatorHelper(bigtableApi, settings, adapter);
    }

    public void close() {
        this.flush();
        try {
            this.helper.close();
        }
        catch (IOException ioException) {
            throw new RuntimeException("could not close buffered mutator", ioException);
        }
    }

    public void flush() {
        this.helper.sendUnsent();
    }

    public Configuration getConfiguration() {
        return this.helper.getConfiguration();
    }

    public TableName getName() {
        return this.helper.getName();
    }

    public long getWriteBufferSize() {
        return this.helper.getWriteBufferSize();
    }

    public List<CompletableFuture<Void>> mutate(List<? extends Mutation> mutations) {
        return this.helper.mutate(mutations).stream().map(apiFuture -> ApiFutureUtils.toCompletableFuture(apiFuture).thenApply(r -> null)).collect(Collectors.toList());
    }

    public CompletableFuture<Void> mutate(Mutation mutation) {
        return ApiFutureUtils.toCompletableFuture(this.helper.mutate(mutation)).thenApply(r -> null);
    }
}

