/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.auto.value.AutoValue;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.AutoValue_AuthorizedViewId;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;

@AutoValue
public abstract class AuthorizedViewId
implements TargetId {
    public static AuthorizedViewId of(String tableId, String authorizedViewId) {
        Preconditions.checkNotNull(tableId, "table id can't be null.");
        Preconditions.checkNotNull(authorizedViewId, "authorized view id can't be null.");
        return new AutoValue_AuthorizedViewId(tableId, authorizedViewId);
    }

    abstract String getTableId();

    abstract String getAuthorizedViewId();

    @Override
    @InternalApi
    public String toResourceName(String projectId, String instanceId) {
        return NameUtil.formatAuthorizedViewName(projectId, instanceId, this.getTableId(), this.getAuthorizedViewId());
    }

    @Override
    @InternalApi
    public boolean scopedForAuthorizedView() {
        return true;
    }
}

