/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.gax.retrying.ServerStreamingAttemptException;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracer;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracerFactory;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.SpanName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.Version;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsConstants;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.bigtable.repackaged.com.google.common.base.Stopwatch;
import com.google.bigtable.repackaged.com.google.common.math.IntMath;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.Attributes;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.DoubleHistogram;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.LongCounter;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

class BuiltinMetricsTracer
extends BigtableTracer {
    private static final String NAME = "java-bigtable/" + Version.VERSION;
    private final ApiTracerFactory.OperationType operationType;
    private final SpanName spanName;
    private final AtomicBoolean opFinished = new AtomicBoolean();
    private final Stopwatch operationTimer = Stopwatch.createStarted();
    private final Stopwatch firstResponsePerOpTimer = Stopwatch.createStarted();
    private int attemptCount = 0;
    private Stopwatch attemptTimer;
    private volatile int attempt = 0;
    private final AtomicLong totalServerLatencyNano = new AtomicLong(0L);
    private final Stopwatch serverLatencyTimer = Stopwatch.createUnstarted();
    private boolean serverLatencyTimerIsRunning = false;
    private final Object timerLock = new Object();
    private boolean flowControlIsDisabled = false;
    private final AtomicInteger requestLeft = new AtomicInteger(0);
    private String tableId = "unspecified";
    private String zone = "global";
    private String cluster = "unspecified";
    private final AtomicLong totalClientBlockingTime = new AtomicLong(0L);
    private final Attributes baseAttributes;
    private Long serverLatencies = null;
    private final DoubleHistogram operationLatenciesHistogram;
    private final DoubleHistogram attemptLatenciesHistogram;
    private final DoubleHistogram serverLatenciesHistogram;
    private final DoubleHistogram firstResponseLatenciesHistogram;
    private final DoubleHistogram clientBlockingLatenciesHistogram;
    private final DoubleHistogram applicationBlockingLatenciesHistogram;
    private final LongCounter connectivityErrorCounter;
    private final LongCounter retryCounter;

    BuiltinMetricsTracer(ApiTracerFactory.OperationType operationType, SpanName spanName, Attributes attributes, DoubleHistogram operationLatenciesHistogram, DoubleHistogram attemptLatenciesHistogram, DoubleHistogram serverLatenciesHistogram, DoubleHistogram firstResponseLatenciesHistogram, DoubleHistogram clientBlockingLatenciesHistogram, DoubleHistogram applicationBlockingLatenciesHistogram, LongCounter connectivityErrorCounter, LongCounter retryCounter) {
        this.operationType = operationType;
        this.spanName = spanName;
        this.baseAttributes = attributes;
        this.operationLatenciesHistogram = operationLatenciesHistogram;
        this.attemptLatenciesHistogram = attemptLatenciesHistogram;
        this.serverLatenciesHistogram = serverLatenciesHistogram;
        this.firstResponseLatenciesHistogram = firstResponseLatenciesHistogram;
        this.clientBlockingLatenciesHistogram = clientBlockingLatenciesHistogram;
        this.applicationBlockingLatenciesHistogram = applicationBlockingLatenciesHistogram;
        this.connectivityErrorCounter = connectivityErrorCounter;
        this.retryCounter = retryCounter;
    }

    @Override
    public ApiTracer.Scope inScope() {
        return new ApiTracer.Scope(){

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void operationSucceeded() {
        this.recordOperationCompletion(null);
    }

    @Override
    public void operationCancelled() {
        this.recordOperationCompletion(new CancellationException());
    }

    @Override
    public void operationFailed(Throwable error) {
        this.recordOperationCompletion(error);
    }

    @Override
    public void attemptStarted(int attemptNumber) {
        this.attemptStarted(null, attemptNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attemptStarted(Object request, int attemptNumber) {
        this.attempt = attemptNumber;
        ++this.attemptCount;
        this.attemptTimer = Stopwatch.createStarted();
        if (request != null) {
            this.tableId = Util.extractTableId(request);
        }
        if (!this.flowControlIsDisabled) {
            Object object = this.timerLock;
            synchronized (object) {
                if (!this.serverLatencyTimerIsRunning) {
                    this.serverLatencyTimer.start();
                    this.serverLatencyTimerIsRunning = true;
                }
            }
        }
    }

    @Override
    public void attemptSucceeded() {
        this.recordAttemptCompletion(null);
    }

    @Override
    public void attemptCancelled() {
        this.recordAttemptCompletion(new CancellationException());
    }

    @Override
    public void attemptFailed(Throwable error, Duration delay) {
        this.recordAttemptCompletion(error);
    }

    @Override
    public void attemptPermanentFailure(Throwable throwable) {
        this.recordAttemptCompletion(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequest(int requestCount) {
        this.requestLeft.accumulateAndGet(requestCount, IntMath::saturatedAdd);
        if (this.flowControlIsDisabled) {
            Object object = this.timerLock;
            synchronized (object) {
                if (!this.serverLatencyTimerIsRunning) {
                    this.serverLatencyTimer.start();
                    this.serverLatencyTimerIsRunning = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseReceived() {
        Object object = this.timerLock;
        synchronized (object) {
            if (this.serverLatencyTimerIsRunning) {
                this.totalServerLatencyNano.addAndGet(this.serverLatencyTimer.elapsed(TimeUnit.NANOSECONDS));
                this.serverLatencyTimer.reset();
                this.serverLatencyTimerIsRunning = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterResponse(long applicationLatency) {
        if (!this.flowControlIsDisabled || this.requestLeft.decrementAndGet() > 0) {
            Object object = this.timerLock;
            synchronized (object) {
                if (!this.serverLatencyTimerIsRunning) {
                    this.serverLatencyTimer.start();
                    this.serverLatencyTimerIsRunning = true;
                }
            }
        }
    }

    @Override
    public int getAttempt() {
        return this.attempt;
    }

    @Override
    public void recordGfeMetadata(@Nullable Long latency, @Nullable Throwable throwable) {
        if (latency != null) {
            this.serverLatencies = latency;
        }
    }

    @Override
    public void setLocations(String zone, String cluster) {
        this.zone = zone;
        this.cluster = cluster;
    }

    @Override
    public void batchRequestThrottled(long throttledTimeNanos) {
        this.totalClientBlockingTime.addAndGet(Duration.ofNanos(throttledTimeNanos).toMillis());
    }

    @Override
    public void grpcChannelQueuedLatencies(long queuedTimeNanos) {
        this.totalClientBlockingTime.addAndGet(queuedTimeNanos);
    }

    @Override
    public void disableFlowControl() {
        this.flowControlIsDisabled = true;
    }

    private void recordOperationCompletion(@Nullable Throwable status) {
        if (!this.opFinished.compareAndSet(false, true)) {
            return;
        }
        this.operationTimer.stop();
        boolean isStreaming = this.operationType == ApiTracerFactory.OperationType.ServerStreaming;
        String statusStr = Util.extractStatus(status);
        Attributes attributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.TABLE_ID_KEY, this.tableId).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, this.cluster).put(BuiltinMetricsConstants.ZONE_ID_KEY, this.zone).put(BuiltinMetricsConstants.METHOD_KEY, this.spanName.toString()).put(BuiltinMetricsConstants.CLIENT_NAME_KEY, NAME).put(BuiltinMetricsConstants.STREAMING_KEY, Boolean.valueOf(isStreaming)).put(BuiltinMetricsConstants.STATUS_KEY, statusStr).build();
        long operationLatencyNano = this.operationTimer.elapsed(TimeUnit.NANOSECONDS);
        if (this.attemptCount > 1) {
            this.retryCounter.add(this.attemptCount - 1, attributes);
        }
        this.operationLatenciesHistogram.record(BuiltinMetricsTracer.convertToMs(operationLatencyNano), attributes);
        long applicationLatencyNano = operationLatencyNano - this.totalServerLatencyNano.get();
        this.applicationBlockingLatenciesHistogram.record(BuiltinMetricsTracer.convertToMs(applicationLatencyNano), attributes);
        if (this.operationType == ApiTracerFactory.OperationType.ServerStreaming && this.spanName.getMethodName().equals("ReadRows")) {
            this.firstResponseLatenciesHistogram.record(BuiltinMetricsTracer.convertToMs(this.firstResponsePerOpTimer.elapsed(TimeUnit.NANOSECONDS)), attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordAttemptCompletion(@Nullable Throwable status) {
        boolean isStreaming;
        Object object = this.timerLock;
        synchronized (object) {
            if (this.serverLatencyTimerIsRunning) {
                this.requestLeft.decrementAndGet();
                this.totalServerLatencyNano.addAndGet(this.serverLatencyTimer.elapsed(TimeUnit.NANOSECONDS));
                this.serverLatencyTimer.reset();
                this.serverLatencyTimerIsRunning = false;
            }
        }
        boolean bl = isStreaming = this.operationType == ApiTracerFactory.OperationType.ServerStreaming;
        if (status instanceof ServerStreamingAttemptException) {
            status = status.getCause();
        }
        String statusStr = Util.extractStatus(status);
        Attributes attributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.TABLE_ID_KEY, this.tableId).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, this.cluster).put(BuiltinMetricsConstants.ZONE_ID_KEY, this.zone).put(BuiltinMetricsConstants.METHOD_KEY, this.spanName.toString()).put(BuiltinMetricsConstants.CLIENT_NAME_KEY, NAME).put(BuiltinMetricsConstants.STREAMING_KEY, Boolean.valueOf(isStreaming)).put(BuiltinMetricsConstants.STATUS_KEY, statusStr).build();
        this.clientBlockingLatenciesHistogram.record(BuiltinMetricsTracer.convertToMs(this.totalClientBlockingTime.get()), attributes);
        this.attemptLatenciesHistogram.record(BuiltinMetricsTracer.convertToMs(this.attemptTimer.elapsed(TimeUnit.NANOSECONDS)), attributes);
        if (this.serverLatencies != null) {
            this.serverLatenciesHistogram.record(this.serverLatencies.longValue(), attributes);
            this.connectivityErrorCounter.add(0L, attributes);
        } else {
            this.connectivityErrorCounter.add(1L, attributes);
        }
    }

    private static double convertToMs(long nanoSeconds) {
        double toMs = 1.0E-6;
        return (double)nanoSeconds * toMs;
    }
}

