/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.ForwardingClientCall;
import com.google.bigtable.repackaged.io.grpc.ForwardingClientCallListener;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Level;
import java.util.logging.Logger;

class ConnectionErrorCountInterceptor
implements ClientInterceptor {
    private static final Logger LOG = Logger.getLogger(ConnectionErrorCountInterceptor.class.toString());
    private final LongAdder numOfErrors = new LongAdder();
    private final LongAdder numOfSuccesses = new LongAdder();

    ConnectionErrorCountInterceptor() {
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(channel.newCall(methodDescriptor, callOptions)){

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    @Override
                    public void onClose(Status status, Metadata trailers) {
                        try {
                            this.handleOnCloseUnsafe(status);
                        }
                        catch (Throwable t) {
                            if (t instanceof InterruptedException) {
                                Thread.currentThread().interrupt();
                            }
                            LOG.log(Level.WARNING, "Unexpected error while updating connection error stats", t);
                        }
                        super.onClose(status, trailers);
                    }

                    private void handleOnCloseUnsafe(Status status) {
                        if (status.isOk()) {
                            ConnectionErrorCountInterceptor.this.numOfSuccesses.increment();
                        } else {
                            ConnectionErrorCountInterceptor.this.numOfErrors.increment();
                        }
                    }
                }, headers);
            }
        };
    }

    long getAndResetNumOfErrors() {
        return this.numOfErrors.sumThenReset();
    }

    long getAndResetNumOfSuccesses() {
        return this.numOfSuccesses.sumThenReset();
    }
}

