/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.ConnectionErrorCountInterceptor;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.opentelemetry.api.OpenTelemetry;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.Attributes;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.LongHistogram;
import com.google.bigtable.repackaged.io.opentelemetry.api.metrics.Meter;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@InternalApi(value="For internal use only")
public class ErrorCountPerConnectionMetricTracker
implements Runnable {
    private static final Integer PER_CONNECTION_ERROR_COUNT_PERIOD_SECONDS = 60;
    private final LongHistogram perConnectionErrorCountHistogram;
    private final Attributes attributes;
    private final Set<ConnectionErrorCountInterceptor> connectionErrorCountInterceptors;
    private final Object interceptorsLock = new Object();

    public ErrorCountPerConnectionMetricTracker(OpenTelemetry openTelemetry, Attributes attributes) {
        this.connectionErrorCountInterceptors = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
        Meter meter = openTelemetry.getMeter("bigtable.googleapis.com/internal/client/");
        this.perConnectionErrorCountHistogram = meter.histogramBuilder("per_connection_error_count").ofLongs().setDescription("Distribution of counts of channels per 'error count per minute'.").setUnit("1").build();
        this.attributes = attributes;
    }

    public void startConnectionErrorCountTracker(ScheduledExecutorService scheduler) {
        scheduler.scheduleAtFixedRate(this, 0L, PER_CONNECTION_ERROR_COUNT_PERIOD_SECONDS.intValue(), TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInterceptor getInterceptor() {
        ConnectionErrorCountInterceptor connectionErrorCountInterceptor = new ConnectionErrorCountInterceptor();
        Object object = this.interceptorsLock;
        synchronized (object) {
            this.connectionErrorCountInterceptors.add(connectionErrorCountInterceptor);
        }
        return connectionErrorCountInterceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.interceptorsLock;
        synchronized (object) {
            for (ConnectionErrorCountInterceptor interceptor : this.connectionErrorCountInterceptors) {
                long errors = interceptor.getAndResetNumOfErrors();
                long successes = interceptor.getAndResetNumOfSuccesses();
                if (errors <= 0L && successes <= 0L) continue;
                this.perConnectionErrorCountHistogram.record(errors, this.attributes);
            }
        }
    }
}

