/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.PartialResultSet;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ProtoRows;
import com.google.bigtable.repackaged.com.google.bigtable.v2.Value;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.ProtoSqlRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.SqlRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.ColumnMetadata;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;

@InternalApi
final class ProtoRowsMergingStateMachine {
    private final ResultSetMetadata metadata;
    private State state;
    private ByteString batchBuffer;
    private ProtoRows completeBatch;

    ProtoRowsMergingStateMachine(ResultSetMetadata metadata) {
        this.metadata = metadata;
        this.state = State.AWAITING_NEW_BATCH;
        this.batchBuffer = ByteString.empty();
    }

    void addPartialResultSet(PartialResultSet results) {
        Preconditions.checkState(this.state != State.AWAITING_BATCH_CONSUME, "Attempting to add partial result set to state machine in state AWAITING_BATCH_CONSUME");
        this.batchBuffer = this.batchBuffer.concat(results.getProtoRowsBatch().getBatchData());
        this.state = State.AWAITING_PARTIAL_BATCH;
        if (results.getResumeToken().isEmpty()) {
            return;
        }
        if (this.batchBuffer.isEmpty()) {
            this.completeBatch = ProtoRows.getDefaultInstance();
        } else {
            try {
                this.completeBatch = ProtoRows.parseFrom(this.batchBuffer);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InternalError("Unexpected exception parsing response protobuf", e);
            }
        }
        this.batchBuffer = ByteString.empty();
        this.state = State.AWAITING_BATCH_CONSUME;
    }

    boolean hasCompleteBatch() {
        return this.state == State.AWAITING_BATCH_CONSUME;
    }

    boolean isBatchInProgress() {
        return this.hasCompleteBatch() || this.state == State.AWAITING_PARTIAL_BATCH;
    }

    void populateQueue(Queue<SqlRow> queue) {
        Preconditions.checkState(this.state == State.AWAITING_BATCH_CONSUME, "Attempting to populate Queue from state machine without completed batch");
        Iterator<Value> valuesIterator = this.completeBatch.getValuesList().iterator();
        while (valuesIterator.hasNext()) {
            ImmutableList.Builder rowDataBuilder = ImmutableList.builder();
            for (ColumnMetadata c : this.metadata.getColumns()) {
                Preconditions.checkState(valuesIterator.hasNext(), "Incomplete row received with first missing column: %s", (Object)c);
                Value v = valuesIterator.next();
                ProtoRowsMergingStateMachine.validateValueAndType(c.type(), v);
                rowDataBuilder.add(v);
            }
            queue.add(ProtoSqlRow.create(this.metadata, (List<Value>)((Object)rowDataBuilder.build())));
        }
        this.completeBatch = ProtoRows.getDefaultInstance();
        this.state = State.AWAITING_NEW_BATCH;
    }

    @InternalApi(value="VisibleForTestingOnly")
    static void validateValueAndType(SqlType<?> type, Value value) {
        if (value.getKindCase() == Value.KindCase.KIND_NOT_SET) {
            return;
        }
        switch (type.getCode()) {
            case STRING: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.STRING_VALUE, type);
                break;
            }
            case BYTES: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.BYTES_VALUE, type);
                break;
            }
            case INT64: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.INT_VALUE, type);
                break;
            }
            case FLOAT64: 
            case FLOAT32: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.FLOAT_VALUE, type);
                break;
            }
            case BOOL: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.BOOL_VALUE, type);
                break;
            }
            case TIMESTAMP: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.TIMESTAMP_VALUE, type);
                break;
            }
            case DATE: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.DATE_VALUE, type);
                break;
            }
            case ARRAY: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.ARRAY_VALUE, type);
                SqlType.Array arrayType = (SqlType.Array)type;
                SqlType elemType = arrayType.getElementType();
                for (Value element : value.getArrayValue().getValuesList()) {
                    ProtoRowsMergingStateMachine.validateValueAndType(elemType, element);
                }
                break;
            }
            case STRUCT: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.ARRAY_VALUE, type);
                List<Value> fieldValues = value.getArrayValue().getValuesList();
                SqlType.Struct structType = (SqlType.Struct)type;
                for (int i = 0; i < fieldValues.size(); ++i) {
                    ProtoRowsMergingStateMachine.validateValueAndType(structType.getType(i), fieldValues.get(i));
                }
                break;
            }
            case MAP: {
                ProtoRowsMergingStateMachine.checkExpectedKind(value, Value.KindCase.ARRAY_VALUE, type);
                SqlType.Map mapType = (SqlType.Map)type;
                for (Value mapElement : value.getArrayValue().getValuesList()) {
                    Preconditions.checkState(mapElement.getArrayValue().getValuesCount() == 2, "Map elements must have exactly 2 elementss");
                    ProtoRowsMergingStateMachine.validateValueAndType(mapType.getKeyType(), mapElement.getArrayValue().getValuesList().get(0));
                    ProtoRowsMergingStateMachine.validateValueAndType(mapType.getValueType(), mapElement.getArrayValue().getValuesList().get(1));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized type: " + type);
            }
        }
    }

    private static void checkExpectedKind(Value value, Value.KindCase expectedKind, SqlType<?> type) {
        Preconditions.checkState(value.getKindCase() == expectedKind, "Value kind must be %s for columns of type: %s", (Object)expectedKind.name(), type);
    }

    static enum State {
        AWAITING_NEW_BATCH,
        AWAITING_PARTIAL_BATCH,
        AWAITING_BATCH_CONSUME;

    }
}

