/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.rls;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.ChannelLogger;
import com.google.bigtable.repackaged.io.grpc.ConnectivityState;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.rls.AdaptiveThrottler;
import com.google.bigtable.repackaged.io.grpc.rls.CachingRlsLbClient;
import com.google.bigtable.repackaged.io.grpc.rls.ChildLbResolvedAddressFactory;
import com.google.bigtable.repackaged.io.grpc.rls.LbPolicyConfiguration;
import javax.annotation.Nullable;

final class RlsLoadBalancer
extends LoadBalancer {
    private final ChannelLogger logger;
    private final LoadBalancer.Helper helper;
    @VisibleForTesting
    CachingRlsLbClientBuilderProvider cachingRlsLbClientBuilderProvider = new DefaultCachingRlsLbClientBuilderProvider();
    @Nullable
    private LbPolicyConfiguration lbPolicyConfiguration;
    @Nullable
    private CachingRlsLbClient routeLookupClient;

    RlsLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.logger = helper.getChannelLogger();
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Rls lb created. Authority: {0}", helper.getAuthority());
    }

    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        LbPolicyConfiguration lbPolicyConfiguration = (LbPolicyConfiguration)resolvedAddresses.getLoadBalancingPolicyConfig();
        Preconditions.checkNotNull(lbPolicyConfiguration, "Missing RLS LB config");
        if (!lbPolicyConfiguration.equals(this.lbPolicyConfiguration)) {
            boolean needToConnect;
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "A new RLS LB config received");
            boolean bl = needToConnect = this.lbPolicyConfiguration == null || !this.lbPolicyConfiguration.getRouteLookupConfig().lookupService().equals(lbPolicyConfiguration.getRouteLookupConfig().lookupService());
            if (needToConnect) {
                this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "RLS lookup service changed, need to connect");
                if (this.routeLookupClient != null) {
                    this.routeLookupClient.close();
                }
                this.routeLookupClient = this.cachingRlsLbClientBuilderProvider.get().setHelper(this.helper).setLbPolicyConfig(lbPolicyConfiguration).setResolvedAddressesFactory(new ChildLbResolvedAddressFactory(resolvedAddresses.getAddresses(), resolvedAddresses.getAttributes())).build();
                this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "LbPolicyConfiguration updated to {0}", lbPolicyConfiguration);
            }
            this.lbPolicyConfiguration = lbPolicyConfiguration;
        }
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "RLS LB accepted resolved addresses successfully");
        return Status.OK;
    }

    @Override
    public void requestConnection() {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "connection requested from RLS LB");
        if (this.routeLookupClient != null) {
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "requesting a connection from the routeLookupClient");
            this.routeLookupClient.requestConnection();
        }
    }

    @Override
    public void handleNameResolutionError(final Status error) {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Received resolution error: {0}", error);
        if (this.routeLookupClient != null) {
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "closing the routeLookupClient on a name resolution error");
            this.routeLookupClient.close();
            this.routeLookupClient = null;
            this.lbPolicyConfiguration = null;
        }
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Updating balancing state to TRANSIENT_FAILURE with an error picker");
        class ErrorPicker
        extends LoadBalancer.SubchannelPicker {
            ErrorPicker() {
            }

            @Override
            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                return LoadBalancer.PickResult.withError(error);
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("error", error).toString();
            }
        }
        this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new ErrorPicker());
    }

    @Override
    public void shutdown() {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Rls lb shutdown");
        if (this.routeLookupClient != null) {
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "closing the routeLookupClient because of RLS LB shutdown");
            this.routeLookupClient.close();
            this.routeLookupClient = null;
        }
    }

    static final class DefaultCachingRlsLbClientBuilderProvider
    implements CachingRlsLbClientBuilderProvider {
        DefaultCachingRlsLbClientBuilderProvider() {
        }

        @Override
        public CachingRlsLbClient.Builder get() {
            return CachingRlsLbClient.newBuilder().setThrottler(AdaptiveThrottler.builder().build());
        }
    }

    static interface CachingRlsLbClientBuilderProvider {
        public CachingRlsLbClient.Builder get();
    }
}

