/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.ClientStreamTracer;
import com.google.bigtable.repackaged.io.grpc.ConnectivityState;
import com.google.bigtable.repackaged.io.grpc.EquivalentAddressGroup;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.LoadBalancerProvider;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.util.MultiChildLoadBalancer;
import com.google.bigtable.repackaged.io.grpc.xds.LeastRequestLoadBalancerProvider;
import com.google.bigtable.repackaged.io.grpc.xds.ThreadSafeRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class LeastRequestLoadBalancer
extends MultiChildLoadBalancer {
    private final ThreadSafeRandom random;
    private LoadBalancer.SubchannelPicker currentPicker = new EmptyPicker();
    private int choiceCount = LeastRequestLoadBalancerProvider.DEFAULT_CHOICE_COUNT;

    LeastRequestLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, ThreadSafeRandom.ThreadSafeRandomImpl.instance);
    }

    @VisibleForTesting
    LeastRequestLoadBalancer(LoadBalancer.Helper helper, ThreadSafeRandom random) {
        super(helper);
        this.random = Preconditions.checkNotNull(random, "random");
    }

    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        Status addressAcceptanceStatus;
        int oldChoiceCount = this.choiceCount;
        LeastRequestConfig config = (LeastRequestConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        if (config != null) {
            this.choiceCount = config.choiceCount;
        }
        if (!(addressAcceptanceStatus = super.acceptResolvedAddresses(resolvedAddresses)).isOk()) {
            this.choiceCount = oldChoiceCount;
        }
        return addressAcceptanceStatus;
    }

    @Override
    protected void updateOverallBalancingState() {
        List<MultiChildLoadBalancer.ChildLbState> activeList = this.getReadyChildren();
        if (activeList.isEmpty()) {
            boolean isConnecting = false;
            ArrayList<MultiChildLoadBalancer.ChildLbState> childrenInTf = new ArrayList<MultiChildLoadBalancer.ChildLbState>();
            for (MultiChildLoadBalancer.ChildLbState childLbState : this.getChildLbStates()) {
                ConnectivityState state = childLbState.getCurrentState();
                if (state == ConnectivityState.CONNECTING || state == ConnectivityState.IDLE) {
                    isConnecting = true;
                    continue;
                }
                if (state != ConnectivityState.TRANSIENT_FAILURE) continue;
                childrenInTf.add(childLbState);
            }
            if (isConnecting) {
                this.updateBalancingState(ConnectivityState.CONNECTING, new EmptyPicker());
            } else {
                this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new ReadyPicker(childrenInTf, this.choiceCount, this.random));
            }
        } else {
            this.updateBalancingState(ConnectivityState.READY, new ReadyPicker(activeList, this.choiceCount, this.random));
        }
    }

    @Override
    protected MultiChildLoadBalancer.ChildLbState createChildLbState(Object key) {
        return new LeastRequestLbState(key, this.pickFirstLbProvider);
    }

    private void updateBalancingState(ConnectivityState state, LoadBalancer.SubchannelPicker picker) {
        if (state != this.currentConnectivityState || !picker.equals(this.currentPicker)) {
            this.getHelper().updateBalancingState(state, picker);
            this.currentConnectivityState = state;
            this.currentPicker = picker;
        }
    }

    @VisibleForTesting
    void setResolvingAddresses(boolean newValue) {
        this.resolvingAddresses = newValue;
    }

    private static AtomicInteger getInFlights(MultiChildLoadBalancer.ChildLbState childLbState) {
        return ((LeastRequestLbState)childLbState).activeRequests;
    }

    protected class LeastRequestLbState
    extends MultiChildLoadBalancer.ChildLbState {
        private final AtomicInteger activeRequests;

        public LeastRequestLbState(Object key, LoadBalancerProvider policyProvider) {
            super(key, policyProvider);
            this.activeRequests = new AtomicInteger(0);
        }

        int getActiveRequests() {
            return this.activeRequests.get();
        }

        @Override
        protected MultiChildLoadBalancer.ChildLbState.ChildLbStateHelper createChildHelper() {
            return new MultiChildLoadBalancer.ChildLbState.ChildLbStateHelper(){

                @Override
                public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                    super.updateBalancingState(newState, newPicker);
                    if (!LeastRequestLoadBalancer.this.resolvingAddresses && newState == ConnectivityState.IDLE) {
                        LeastRequestLbState.this.getLb().requestConnection();
                    }
                }
            };
        }
    }

    static final class LeastRequestConfig {
        final int choiceCount;

        LeastRequestConfig(int choiceCount) {
            Preconditions.checkArgument(choiceCount >= 2, "choiceCount <= 1");
            this.choiceCount = Math.min(choiceCount, 10);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("choiceCount", this.choiceCount).toString();
        }
    }

    private static final class OutstandingRequestsTracingFactory
    extends ClientStreamTracer.Factory {
        private final AtomicInteger inFlights;

        private OutstandingRequestsTracingFactory(AtomicInteger inFlights) {
            this.inFlights = Preconditions.checkNotNull(inFlights, "inFlights");
        }

        @Override
        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            return new ClientStreamTracer(){

                @Override
                public void streamCreated(Attributes transportAttrs, Metadata headers) {
                    inFlights.incrementAndGet();
                }

                @Override
                public void streamClosed(Status status) {
                    inFlights.decrementAndGet();
                }
            };
        }
    }

    @VisibleForTesting
    static final class EmptyPicker
    extends LoadBalancer.SubchannelPicker {
        EmptyPicker() {
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withNoResult();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof EmptyPicker;
        }

        public String toString() {
            return MoreObjects.toStringHelper(EmptyPicker.class).toString();
        }
    }

    @VisibleForTesting
    static final class ReadyPicker
    extends LoadBalancer.SubchannelPicker {
        private final List<LoadBalancer.SubchannelPicker> childPickers;
        private final List<AtomicInteger> childInFlights;
        private final List<EquivalentAddressGroup> childEags;
        private final int choiceCount;
        private final ThreadSafeRandom random;
        private final int hashCode;

        ReadyPicker(List<MultiChildLoadBalancer.ChildLbState> childLbStates, int choiceCount, ThreadSafeRandom random) {
            Preconditions.checkArgument(!childLbStates.isEmpty(), "empty list");
            this.childPickers = new ArrayList<LoadBalancer.SubchannelPicker>(childLbStates.size());
            this.childInFlights = new ArrayList<AtomicInteger>(childLbStates.size());
            this.childEags = new ArrayList<EquivalentAddressGroup>(childLbStates.size());
            for (MultiChildLoadBalancer.ChildLbState state : childLbStates) {
                this.childPickers.add(state.getCurrentPicker());
                this.childInFlights.add(LeastRequestLoadBalancer.getInFlights(state));
                this.childEags.add(state.getEag());
            }
            this.choiceCount = choiceCount;
            this.random = Preconditions.checkNotNull(random, "random");
            int sum = 0;
            for (LoadBalancer.SubchannelPicker child : this.childPickers) {
                sum += child.hashCode();
            }
            this.hashCode = sum ^ choiceCount;
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            int child = this.nextChildToUse();
            LoadBalancer.PickResult childResult = this.childPickers.get(child).pickSubchannel(args);
            if (!childResult.getStatus().isOk() || childResult.getSubchannel() == null) {
                return childResult;
            }
            if (childResult.getStreamTracerFactory() != null) {
                return childResult;
            }
            OutstandingRequestsTracingFactory factory = new OutstandingRequestsTracingFactory(this.childInFlights.get(child));
            return LoadBalancer.PickResult.withSubchannel(childResult.getSubchannel(), factory);
        }

        public String toString() {
            return MoreObjects.toStringHelper(ReadyPicker.class).add("list", this.childPickers).add("choiceCount", this.choiceCount).toString();
        }

        private int nextChildToUse() {
            int candidate = this.random.nextInt(this.childPickers.size());
            for (int i = 0; i < this.choiceCount - 1; ++i) {
                int sampled = this.random.nextInt(this.childPickers.size());
                if (this.childInFlights.get(sampled).get() >= this.childInFlights.get(candidate).get()) continue;
                candidate = sampled;
            }
            return candidate;
        }

        @VisibleForTesting
        List<LoadBalancer.SubchannelPicker> getChildPickers() {
            return this.childPickers;
        }

        @VisibleForTesting
        List<EquivalentAddressGroup> getChildEags() {
            return this.childEags;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ReadyPicker)) {
                return false;
            }
            ReadyPicker other = (ReadyPicker)o;
            if (other == this) {
                return true;
            }
            return this.hashCode == other.hashCode && this.choiceCount == other.choiceCount && this.childPickers.size() == other.childPickers.size() && new HashSet<LoadBalancer.SubchannelPicker>(this.childPickers).containsAll(other.childPickers);
        }
    }
}

