/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.api.incubator.events;

import com.google.bigtable.repackaged.io.opentelemetry.api.common.AttributeKey;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.Attributes;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.Value;
import com.google.bigtable.repackaged.io.opentelemetry.api.logs.Severity;
import com.google.bigtable.repackaged.io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public interface EventBuilder {
    default public EventBuilder put(String key, String value) {
        return this.put(key, Value.of(value));
    }

    default public EventBuilder put(String key, long value) {
        return this.put(key, Value.of(value));
    }

    default public EventBuilder put(String key, double value) {
        return this.put(key, Value.of(value));
    }

    default public EventBuilder put(String key, boolean value) {
        return this.put(key, Value.of(value));
    }

    default public EventBuilder put(String key, String ... value) {
        ArrayList values = new ArrayList(value.length);
        for (String val : value) {
            values.add(Value.of(val));
        }
        return this.put(key, Value.of(values));
    }

    default public EventBuilder put(String key, long ... value) {
        ArrayList values = new ArrayList(value.length);
        for (long val : value) {
            values.add(Value.of(val));
        }
        return this.put(key, Value.of(values));
    }

    default public EventBuilder put(String key, double ... value) {
        ArrayList values = new ArrayList(value.length);
        for (double val : value) {
            values.add(Value.of(val));
        }
        return this.put(key, Value.of(values));
    }

    default public EventBuilder put(String key, boolean ... value) {
        ArrayList values = new ArrayList(value.length);
        for (boolean val : value) {
            values.add(Value.of(val));
        }
        return this.put(key, Value.of(values));
    }

    default public <T> EventBuilder put(AttributeKey<T> key, T value) {
        switch (key.getType()) {
            case STRING: {
                return this.put(key.getKey(), (String)value);
            }
            case BOOLEAN: {
                return this.put(key.getKey(), (boolean)((Boolean)value));
            }
            case LONG: {
                return this.put(key.getKey(), (long)((Long)value));
            }
            case DOUBLE: {
                return this.put(key.getKey(), (double)((Double)value));
            }
            case STRING_ARRAY: {
                return this.put(key.getKey(), Value.of(((List)value).stream().map(Value::of).collect(Collectors.toList())));
            }
            case BOOLEAN_ARRAY: {
                return this.put(key.getKey(), Value.of(((List)value).stream().map(Value::of).collect(Collectors.toList())));
            }
            case LONG_ARRAY: {
                return this.put(key.getKey(), Value.of(((List)value).stream().map(Value::of).collect(Collectors.toList())));
            }
            case DOUBLE_ARRAY: {
                return this.put(key.getKey(), Value.of(((List)value).stream().map(Value::of).collect(Collectors.toList())));
            }
        }
        return this;
    }

    public EventBuilder put(String var1, Value<?> var2);

    public EventBuilder setTimestamp(long var1, TimeUnit var3);

    public EventBuilder setTimestamp(Instant var1);

    public EventBuilder setContext(Context var1);

    public EventBuilder setSeverity(Severity var1);

    public EventBuilder setAttributes(Attributes var1);

    public void emit();
}

