/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state;

import com.google.bigtable.repackaged.com.google.auto.value.AutoValue;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.Attributes;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.AutoValue_ImmutableMeasurement;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.state.Measurement;

@AutoValue
public abstract class ImmutableMeasurement
implements Measurement {
    static ImmutableMeasurement createDouble(long startEpochNanos, long epochNanos, double value, Attributes attributes) {
        return new AutoValue_ImmutableMeasurement(startEpochNanos, epochNanos, false, 0L, true, value, attributes);
    }

    static ImmutableMeasurement createLong(long startEpochNanos, long epochNanos, long value, Attributes attributes) {
        return new AutoValue_ImmutableMeasurement(startEpochNanos, epochNanos, true, value, false, 0.0, attributes);
    }

    @Override
    public Measurement withAttributes(Attributes attributes) {
        if (this.hasDoubleValue()) {
            return ImmutableMeasurement.createDouble(this.startEpochNanos(), this.epochNanos(), this.doubleValue(), attributes);
        }
        return ImmutableMeasurement.createLong(this.startEpochNanos(), this.epochNanos(), this.longValue(), attributes);
    }

    @Override
    public Measurement withStartEpochNanos(long startEpochNanos) {
        if (this.hasDoubleValue()) {
            return ImmutableMeasurement.createDouble(startEpochNanos, this.epochNanos(), this.doubleValue(), this.attributes());
        }
        return ImmutableMeasurement.createLong(startEpochNanos, this.epochNanos(), this.longValue(), this.attributes());
    }
}

