/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase2_x;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutureCallback;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CompletableFuture;

@InternalApi(value="For internal usage only")
public class ApiFutureUtils {
    public static <T> CompletableFuture<T> toCompletableFuture(final ApiFuture<T> apiFuture) {
        final CompletableFuture completableFuture = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean result = apiFuture.cancel(mayInterruptIfRunning);
                super.cancel(mayInterruptIfRunning);
                return result;
            }
        };
        ApiFutureCallback callback = new ApiFutureCallback<T>(){

            @Override
            public void onFailure(Throwable throwable) {
                completableFuture.completeExceptionally(throwable);
            }

            @Override
            public void onSuccess(T t) {
                completableFuture.complete(t);
            }
        };
        ApiFutures.addCallback(apiFuture, callback, MoreExecutors.directExecutor());
        return completableFuture;
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable error) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(error);
        return future;
    }
}

