/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase2_x;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.base.Throwables;
import com.google.bigtable.repackaged.net.bytebuddy.ByteBuddy;
import com.google.bigtable.repackaged.net.bytebuddy.implementation.InvocationHandlerAdapter;
import com.google.bigtable.repackaged.net.bytebuddy.matcher.ElementMatchers;
import com.google.cloud.bigtable.hbase.util.FutureUtil;
import com.google.cloud.bigtable.hbase.util.ModifyTableBuilder;
import com.google.cloud.bigtable.hbase2_x.ApiFutureUtils;
import com.google.cloud.bigtable.hbase2_x.BigtableAsyncAdmin;
import com.google.cloud.bigtable.hbase2_x.adapters.admin.TableAdapter2x;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractBigtableAdmin;
import org.apache.hadoop.hbase.client.AbstractBigtableConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi(value="For internal usage only")
public abstract class BigtableAdmin
extends AbstractBigtableAdmin {
    private final BigtableAsyncAdmin asyncAdmin;
    private static Class<? extends BigtableAdmin> adminClass = null;

    public BigtableAdmin(AbstractBigtableConnection connection) throws IOException {
        super(connection);
        this.asyncAdmin = BigtableAsyncAdmin.createInstance(connection);
    }

    public void createTable(TableDescriptor desc) throws IOException {
        this.createTable(desc, (byte[][])null);
    }

    public void createTable(TableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        this.createTable(desc, BigtableAdmin.createSplitKeys(startKey, endKey, numRegions));
    }

    public void createTable(TableDescriptor desc, byte[][] splitKeys) throws IOException {
        this.createTable(desc.getTableName(), TableAdapter2x.adapt(desc, splitKeys));
    }

    public Future<Void> createTableAsync(TableDescriptor tableDescriptor) throws IOException {
        return this.asyncAdmin.createTable(tableDescriptor);
    }

    public Future<Void> createTableAsync(TableDescriptor desc, byte[][] splitKeys) throws IOException {
        return this.asyncAdmin.createTable(desc, splitKeys);
    }

    public void addColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamilyDesc) throws IOException {
        this.modifyColumns(tableName, columnFamilyDesc.getNameAsString(), "add", ModifyTableBuilder.newBuilder(tableName).add(TableAdapter2x.toHColumnDescriptor(columnFamilyDesc)));
    }

    public void modifyColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamilyDesc) throws IOException {
        this.modifyColumns(tableName, columnFamilyDesc.getNameAsString(), "modify", ModifyTableBuilder.newBuilder(tableName).modify(TableAdapter2x.toHColumnDescriptor(columnFamilyDesc)));
    }

    public Future<Void> deleteNamespaceAsync(String name) throws IOException {
        this.deleteNamespace(name);
        return CompletableFuture.runAsync(() -> {});
    }

    public Future<Void> disableTableAsync(TableName tableName) throws IOException {
        return this.asyncAdmin.disableTable(tableName);
    }

    public Future<Void> enableTableAsync(TableName tableName) throws IOException {
        return this.asyncAdmin.enableTable(tableName);
    }

    public TableDescriptor getDescriptor(TableName tableName) throws IOException {
        return this.getTableDescriptor(tableName);
    }

    public Future<Void> addColumnFamilyAsync(TableName tableName, ColumnFamilyDescriptor columnFamily) {
        return this.asyncAdmin.addColumnFamily(tableName, columnFamily);
    }

    public void deleteColumnFamily(TableName tableName, byte[] columnName) throws IOException {
        this.deleteColumn(tableName, columnName);
    }

    public Future<Void> deleteColumnFamilyAsync(TableName tableName, byte[] columnName) {
        return this.asyncAdmin.deleteColumnFamily(tableName, columnName);
    }

    protected CompletableFuture<Void> deleteTableAsyncInternal(TableName tableName) {
        return ApiFutureUtils.toCompletableFuture(this.adminClientWrapper.deleteTableAsync(tableName.getNameAsString()));
    }

    public Future<Void> deleteTableAsync(TableName tableName) throws IOException {
        return this.deleteTableAsyncInternal(tableName);
    }

    public List<TableDescriptor> listTableDescriptors() throws IOException {
        return Arrays.asList(this.listTables());
    }

    public List<TableDescriptor> listTableDescriptors(Pattern pattern) throws IOException {
        return Arrays.asList(this.listTables(pattern));
    }

    public List<TableDescriptor> listTableDescriptors(List<TableName> tableNames) throws IOException {
        ArrayList<TableDescriptor> response = new ArrayList<TableDescriptor>();
        for (TableName tableName : tableNames) {
            HTableDescriptor desc = this.getTableDescriptor(tableName);
            if (desc == null) continue;
            response.add((TableDescriptor)desc);
        }
        return response;
    }

    public List<TableDescriptor> listTableDescriptors(Pattern pattern, boolean includeSysTables) throws IOException {
        return Arrays.asList(this.listTables(pattern, includeSysTables));
    }

    public List<TableDescriptor> listTableDescriptorsByNamespace(byte[] namespace) throws IOException {
        String namespaceStr = Bytes.toString((byte[])namespace);
        return Arrays.asList(this.listTableDescriptorsByNamespace(namespaceStr));
    }

    public Future<Void> modifyColumnFamilyAsync(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        return this.asyncAdmin.modifyColumnFamily(tableName, columnFamily);
    }

    public void modifyTable(TableDescriptor tableDescriptor) throws IOException {
        this.modifyTable(tableDescriptor.getTableName(), tableDescriptor);
    }

    public void modifyTable(TableName tableName, TableDescriptor tableDescriptor) throws IOException {
        FutureUtil.unwrap(this.modifyTableAsync(tableName, tableDescriptor));
    }

    public Future<Void> modifyTableAsync(TableDescriptor tableDescriptor) throws IOException {
        return this.modifyTableAsync(tableDescriptor.getTableName(), tableDescriptor);
    }

    public Future<Void> modifyTableAsync(TableName tableName, TableDescriptor newDescriptor) {
        return ((CompletableFuture)this.asyncAdmin.getDescriptor(tableName).thenApply(descriptor -> ModifyTableBuilder.buildModifications(new HTableDescriptor(newDescriptor), new HTableDescriptor(descriptor)))).thenApply(modifications -> {
            try {
                return this.modifyColumns(tableName, null, "modifyTableAsync", (ModifyTableBuilder)modifications);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public Future<Void> truncateTableAsync(TableName tableName, boolean preserveSplits) throws IOException {
        if (!preserveSplits) {
            this.LOG.info("truncate will preserveSplits. The passed in variable is ignored.", new Object[0]);
        }
        return ApiFutureUtils.toCompletableFuture(this.adminClientWrapper.dropAllRowsAsync(tableName.getNameAsString()));
    }

    public List<RegionInfo> getRegions(TableName tableName) throws IOException {
        ArrayList<RegionInfo> regionInfo = new ArrayList<RegionInfo>();
        for (HRegionInfo hRegionInfo : this.getTableRegions(tableName)) {
            regionInfo.add((RegionInfo)hRegionInfo);
        }
        return regionInfo;
    }

    public ClusterMetrics getClusterMetrics(EnumSet<ClusterMetrics.Option> arg0) throws IOException {
        return this.getClusterStatus();
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return new ClusterStatus("hbaseVersion", "clusterid", new HashMap(), new ArrayList(), null, new ArrayList(), new ArrayList(), new String[0], Boolean.valueOf(false), -1);
    }

    public List<RegionMetrics> getRegionMetrics(ServerName serverName, TableName tableName) throws IOException {
        return FutureUtil.unwrap(this.asyncAdmin.getRegionMetrics(serverName, tableName));
    }

    private static synchronized Class<? extends BigtableAdmin> getSubclass() throws NoSuchMethodException {
        if (adminClass == null) {
            adminClass = new ByteBuddy().subclass(BigtableAdmin.class).method(ElementMatchers.isAbstract()).intercept(InvocationHandlerAdapter.of(new AbstractBigtableAdmin.UnsupportedOperationsHandler())).make().load(BigtableAdmin.class.getClassLoader()).getLoaded();
        }
        return adminClass;
    }

    public static BigtableAdmin createInstance(AbstractBigtableConnection connection) throws IOException {
        try {
            return BigtableAdmin.getSubclass().getDeclaredConstructor(AbstractBigtableConnection.class).newInstance(connection);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfInstanceOf(e.getTargetException(), IOException.class);
            Throwables.throwIfInstanceOf(e.getTargetException(), RuntimeException.class);
            throw new IOException(e);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

