/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.batch.common;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.TransportChannelProvider;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.batch.common.CloudBigtableService;
import com.google.cloud.bigtable.beam.CloudBigtableTableConfiguration;
import com.google.cloud.bigtable.hbase.wrappers.veneer.BigtableHBaseVeneerSettings;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

@InternalApi(value="For internal usage only")
public class CloudBigtableServiceImpl
implements CloudBigtableService {
    @Override
    public List<KeyOffset> getSampleRowKeys(CloudBigtableTableConfiguration config) throws IOException {
        BigtableHBaseVeneerSettings settings = BigtableHBaseVeneerSettings.create((Configuration)config.toHBaseConfig());
        BigtableDataSettings.Builder builder = settings.getDataSettings().toBuilder();
        InstantiatingGrpcChannelProvider oldTransportProvider = (InstantiatingGrpcChannelProvider)settings.getDataSettings().getStubSettings().getTransportChannelProvider();
        builder.stubSettings().setTransportChannelProvider((TransportChannelProvider)oldTransportProvider.toBuilder().setChannelPoolSettings(ChannelPoolSettings.staticallySized((int)1).toBuilder().setPreemptiveRefreshEnabled(false).build()).build());
        try (BigtableDataClient client = BigtableDataClient.create((BigtableDataSettings)builder.build());){
            List list = client.sampleRowKeys(config.getTableId());
            return list;
        }
    }
}

