/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam;

import com.google.bigtable.repackaged.com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.repackaged.io.grpc.BindableService;
import com.google.bigtable.repackaged.io.grpc.ServerBuilder;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import com.google.cloud.bigtable.beam.CloudBigtableIO;
import com.google.cloud.bigtable.beam.CloudBigtableTableConfiguration;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class BulkMutationCloseTimeoutTest {
    @Rule
    public TestPipeline writePipeline = TestPipeline.create();
    @Rule
    public final TemporaryFolder workDir = new TemporaryFolder();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test(timeout=20000L)
    public void testBulkMutationCloseTimeout() throws Throwable {
        this.thrown.expect(Pipeline.PipelineExecutionException.class);
        this.thrown.expectMessage("Cloud not close the bulk mutation Batcher, timed out in close()");
        int port = this.startFakeBigtableService();
        ArrayList<Put> data = new ArrayList<Put>();
        for (int i = 0; i < 1; ++i) {
            Put row = new Put(Bytes.toBytes((String)"key-123"));
            row.addColumn(Bytes.toBytes((String)"column-family"), Bytes.toBytes((String)"column"), Bytes.toBytes((String)"value"));
            data.add(row);
        }
        CloudBigtableTableConfiguration config = new CloudBigtableTableConfiguration.Builder().withProjectId("test-project").withInstanceId("test-instance").withTableId("test-table").withConfiguration("google.bigtable.emulator.endpoint.host", "localhost:" + port).withConfiguration("bulk.mutation.close.timeout.milliseconds", "10000").build();
        CloudBigtableIO.writeToTable((CloudBigtableTableConfiguration)config);
        ((PCollection)this.writePipeline.apply((PTransform)Create.of(data))).apply(CloudBigtableIO.writeToTable((CloudBigtableTableConfiguration)config));
        this.writePipeline.run().waitUntilFinish();
    }

    private int startFakeBigtableService() throws IOException {
        int port;
        try (ServerSocket ss = new ServerSocket(0);){
            port = ss.getLocalPort();
        }
        ServerBuilder builder = ServerBuilder.forPort((int)port);
        builder.addService((BindableService)new FakeBigtableService());
        builder.build().start();
        System.out.println("Starting FakeBigtableService on port: " + port);
        return port;
    }

    public static class FakeBigtableService
    extends BigtableGrpc.BigtableImplBase {
        public void mutateRows(MutateRowsRequest request, StreamObserver<MutateRowsResponse> observer) {
        }
    }
}

