/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam;

import com.google.bigtable.repackaged.com.google.cloud.bigtable.Version;
import com.google.cloud.bigtable.beam.CloudBigtableConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.hadoop.conf.Configuration;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CloudBigtableConfigurationTest {
    private static final String PROJECT = "my_project";
    private static final String INSTANCE = "instance";

    private CloudBigtableConfiguration.Builder createBaseBuilder() {
        return this.createBaseBuilder(PROJECT, INSTANCE);
    }

    private CloudBigtableConfiguration.Builder createBaseBuilder(String project, String instance) {
        return new CloudBigtableConfiguration.Builder().withProjectId(project).withInstanceId(instance);
    }

    @Test
    public void testToBuilder() {
        CloudBigtableConfiguration underTest = this.createBaseBuilder().withConfiguration("somekey", "somevalue").build();
        CloudBigtableConfiguration copy = underTest.toBuilder().build();
        Assert.assertNotSame((Object)underTest, (Object)copy);
        Assert.assertEquals((Object)underTest, (Object)copy);
    }

    @Test
    public void testHBaseConfig() {
        CloudBigtableConfiguration underTest = this.createBaseBuilder().build();
        Configuration config = underTest.toHBaseConfig();
        Assert.assertEquals((Object)PROJECT, (Object)config.get("google.bigtable.project.id"));
        Assert.assertEquals((Object)INSTANCE, (Object)config.get("google.bigtable.instance.id"));
    }

    @Test
    public void testEquals() {
        CloudBigtableConfiguration underTest1 = this.createBaseBuilder().build();
        CloudBigtableConfiguration underTest2 = this.createBaseBuilder().build();
        CloudBigtableConfiguration underTest3 = this.createBaseBuilder().withConfiguration("somekey", "somevalue").build();
        CloudBigtableConfiguration underTest4 = this.createBaseBuilder("other_project", INSTANCE).build();
        CloudBigtableConfiguration underTest5 = this.createBaseBuilder().withConfiguration("somekey", "somevalue").build();
        Assert.assertEquals((Object)underTest1, (Object)underTest2);
        Assert.assertNotEquals((Object)underTest1, (Object)underTest3);
        Assert.assertNotEquals((Object)underTest1, (Object)underTest4);
        Assert.assertEquals((Object)underTest3, (Object)underTest5);
    }

    @Test
    public void testRegularAndRuntimeParametersAreEqual() {
        CloudBigtableConfiguration withRegularParameters = this.createBaseBuilder().withConfiguration("somekey", "somevalue").build();
        CloudBigtableConfiguration withRuntimeParameters = new CloudBigtableConfiguration.Builder().withProjectId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)PROJECT)).withInstanceId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)INSTANCE)).withConfiguration("somekey", (ValueProvider)ValueProvider.StaticValueProvider.of((Object)"somevalue")).build();
        Assert.assertNotSame((Object)withRegularParameters, (Object)withRuntimeParameters);
        Assert.assertEquals((Object)withRegularParameters, (Object)withRuntimeParameters);
    }

    @Test
    public void testPopulateDisplayData() {
        CloudBigtableConfiguration config = this.createBaseBuilder().withConfiguration("somekey", "somevalue").withConfiguration("inaccessible", (ValueProvider)new InaccessibleValueProvider()).build();
        TestDisplayDataBuilder builder = new TestDisplayDataBuilder();
        config.populateDisplayData((DisplayData.Builder)builder);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("null:projectId=my_project");
        expected.add("null:instanceId=instance");
        expected.add("null:somekey=somevalue");
        expected.add("null:google.bigtable.project.id=my_project");
        expected.add("null:google.bigtable.instance.id=instance");
        expected.add("null:inaccessible=Unavailable during pipeline construction");
        expected.add("null:bigtableClientVersion=" + Version.VERSION);
        MatcherAssert.assertThat((Object)builder.itemStrings, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])expected.toArray()));
    }

    private static class InaccessibleValueProvider
    implements ValueProvider<String> {
        private InaccessibleValueProvider() {
        }

        public String get() {
            return null;
        }

        public boolean isAccessible() {
            return false;
        }
    }

    private static class TestDisplayDataBuilder
    implements DisplayData.Builder {
        private List<String> itemStrings = new ArrayList<String>();

        private TestDisplayDataBuilder() {
        }

        public DisplayData.Builder include(String path, HasDisplayData subComponent) {
            return this;
        }

        public DisplayData.Builder delegate(HasDisplayData component) {
            return this;
        }

        public DisplayData.Builder add(DisplayData.ItemSpec<?> item) {
            this.itemStrings.add(item.toString());
            return this;
        }

        public DisplayData.Builder addIfNotNull(DisplayData.ItemSpec<?> item) {
            return this;
        }

        public <T> DisplayData.Builder addIfNotDefault(DisplayData.ItemSpec<T> item, @Nullable T defaultValue) {
            return this;
        }
    }
}

