/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam;

import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.beam.CloudBigtableConfiguration;
import com.google.cloud.bigtable.beam.CloudBigtableIO;
import com.google.cloud.bigtable.beam.CloudBigtableScanConfiguration;
import com.google.cloud.bigtable.beam.CloudBigtableTableConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

@RunWith(value=JUnit4.class)
public class CloudBigtableIOTest {
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    Pipeline underTest;
    private static final CoderRegistry registry = CoderRegistry.createDefault();
    private CloudBigtableScanConfiguration scanConfig = new CloudBigtableScanConfiguration.Builder().withProjectId("project").withInstanceId("instanceId").withTableId("table").build();

    @Before
    public void setup() {
        Mockito.when((Object)this.underTest.getCoderRegistry()).thenReturn((Object)registry);
    }

    private void checkRegistry(Class<? extends Mutation> mutationClass) throws CannotProvideCoderException {
        Coder coder = registry.getCoder(TypeDescriptor.of(mutationClass));
        Assert.assertNotNull((Object)coder);
    }

    @Test
    public void testInitialize() throws Exception {
        this.checkRegistry(Put.class);
        this.checkRegistry(Delete.class);
        this.checkRegistry(Mutation.class);
    }

    @Test
    public void testSourceToString() throws Exception {
        CloudBigtableIO.Source source = (CloudBigtableIO.Source)CloudBigtableIO.read((CloudBigtableScanConfiguration)this.scanConfig);
        byte[] startKey = "abc d".getBytes();
        byte[] stopKey = "def g".getBytes();
        CloudBigtableIO.SourceWithKeys sourceWithKeys = source.createSourceWithKeys(startKey, stopKey, 10L);
        Assert.assertEquals((Object)"Split start: 'abc d', end: 'def g', size: 10.", (Object)sourceWithKeys.toString());
        startKey = new byte[]{0, 1, 2, 3, 4, 5};
        stopKey = new byte[]{104, 101, 108, 108, 111};
        sourceWithKeys = source.createSourceWithKeys(startKey, stopKey, 10L);
        Assert.assertEquals((Object)"Split start: '\\x00\\x01\\x02\\x03\\x04\\x05', end: 'hello', size: 10.", (Object)sourceWithKeys.toString());
    }

    @Test
    public void testSampleRowKeys() throws Exception {
        ArrayList<KeyOffset> sampleRowKeys = new ArrayList<KeyOffset>();
        int count = 46075;
        byte[][] keys = Bytes.split((byte[])"A".getBytes(), (byte[])"Z".getBytes(), (int)(count - 2));
        long tabletSize = 0x80000000L;
        long boundary = 0L;
        for (byte[] currentKey : keys) {
            boundary += tabletSize;
            try {
                sampleRowKeys.add(KeyOffset.create((ByteString)ByteString.copyFrom((byte[])currentKey), (long)boundary));
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
                return;
            }
        }
        CloudBigtableIO.Source source = (CloudBigtableIO.Source)CloudBigtableIO.read((CloudBigtableScanConfiguration)this.scanConfig);
        source.setSampleRowKeys(sampleRowKeys);
        List splits = source.getSplits(20000L);
        Collections.sort(splits, new Comparator<CloudBigtableIO.SourceWithKeys>(){

            @Override
            public int compare(CloudBigtableIO.SourceWithKeys o1, CloudBigtableIO.SourceWithKeys o2) {
                return ByteStringComparator.INSTANCE.compare(ByteString.copyFrom((byte[])o1.getConfiguration().getStartRow()), ByteString.copyFrom((byte[])o2.getConfiguration().getStartRow()));
            }
        });
        Assert.assertTrue(((long)splits.size() <= 15360L ? 1 : 0) != 0);
        Iterator iter = splits.iterator();
        CloudBigtableIO.SourceWithKeys last = (CloudBigtableIO.SourceWithKeys)iter.next();
        while (iter.hasNext()) {
            CloudBigtableIO.SourceWithKeys current = (CloudBigtableIO.SourceWithKeys)iter.next();
            Assert.assertTrue((boolean)Bytes.equals((byte[])current.getConfiguration().getStartRow(), (byte[])last.getConfiguration().getStopRow()));
            if (iter.hasNext()) {
                Assert.assertTrue((Bytes.compareTo((byte[])current.getConfiguration().getStartRow(), (byte[])current.getConfiguration().getStopRow()) < 0 ? 1 : 0) != 0);
            }
            Assert.assertTrue((current.getEstimatedSize() >= tabletSize ? 1 : 0) != 0);
            last = current;
        }
    }

    @Test
    public void testWriteToTableValidateConfig() throws Exception {
        CloudBigtableIO.writeToTable((CloudBigtableTableConfiguration)this.scanConfig).validate(null);
        try {
            CloudBigtableIO.writeToTable((CloudBigtableTableConfiguration)this.scanConfig.toBuilder().withProjectId("").build()).validate(null);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("A projectId must be set"));
        }
        try {
            CloudBigtableIO.writeToTable((CloudBigtableTableConfiguration)this.scanConfig.toBuilder().withInstanceId("").build()).validate(null);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("A instanceId must be set"));
        }
        try {
            CloudBigtableIO.writeToTable((CloudBigtableTableConfiguration)this.scanConfig.toBuilder().withTableId("").build()).validate(null);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("A tableid must be set"));
        }
    }

    @Test
    public void testWriteToMultipleTablesValidateConfig() throws Exception {
        CloudBigtableConfiguration config = new CloudBigtableConfiguration.Builder().withProjectId("project").withInstanceId("instanceId").build();
        CloudBigtableIO.writeToMultipleTables((CloudBigtableConfiguration)config).validate(null);
        try {
            CloudBigtableIO.writeToMultipleTables((CloudBigtableConfiguration)config.toBuilder().withProjectId("").build()).validate(null);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("A projectId must be set"));
        }
        try {
            CloudBigtableIO.writeToMultipleTables((CloudBigtableConfiguration)config.toBuilder().withInstanceId("").build()).validate(null);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("A instanceId must be set"));
        }
    }

    @Test
    public void testSerializeSource() {
        String projectId = "my-project";
        String instanceId = "my-instance";
        String tableId = "my-table";
        Scan scan = new Scan().setFilter((Filter)new KeyOnlyFilter()).setMaxVersions(2);
        CloudBigtableScanConfiguration configuration = CloudBigtableScanConfiguration.createConfig((ValueProvider)ValueProvider.StaticValueProvider.of((Object)projectId), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)instanceId), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)tableId), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)scan), new HashMap());
        CloudBigtableIO.Source source = new CloudBigtableIO.Source(configuration);
        CloudBigtableIO.Source deserialized = (CloudBigtableIO.Source)SerializableUtils.ensureSerializable((Serializable)source);
        Assert.assertEquals((Object)projectId, (Object)deserialized.getConfiguration().getProjectId());
        Assert.assertEquals((Object)instanceId, (Object)deserialized.getConfiguration().getInstanceId());
        Assert.assertEquals((Object)tableId, (Object)deserialized.getConfiguration().getTableId());
        Assert.assertEquals((Object)scan.getFilter(), (Object)((Scan)deserialized.getConfiguration().getScanValueProvider().get()).getFilter());
        Assert.assertEquals((long)2L, (long)scan.getMaxVersions());
    }

    @Test
    public void testSerializeSourceWithKeys() {
        String projectId = "my-project";
        String instanceId = "my-instance";
        String tableId = "my-table";
        String startKey = "aaa1";
        String endKey = "bbb3";
        Scan scan = new Scan().withStartRow(ByteString.copyFromUtf8((String)startKey).toByteArray()).withStopRow(ByteString.copyFromUtf8((String)endKey).toByteArray()).setFilter((Filter)new KeyOnlyFilter());
        CloudBigtableScanConfiguration sourceWithKeysConfiguration = CloudBigtableScanConfiguration.createConfig((ValueProvider)ValueProvider.StaticValueProvider.of((Object)projectId), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)instanceId), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)tableId), (ValueProvider)ValueProvider.StaticValueProvider.of((Object)scan), new HashMap());
        long estimatedSize = 123456L;
        CloudBigtableIO.SourceWithKeys sourceWithKeys = new CloudBigtableIO.SourceWithKeys(sourceWithKeysConfiguration, estimatedSize);
        CloudBigtableIO.SourceWithKeys deserialized = (CloudBigtableIO.SourceWithKeys)SerializableUtils.ensureSerializable((Serializable)sourceWithKeys);
        Assert.assertEquals((Object)projectId, (Object)deserialized.getConfiguration().getProjectId());
        Assert.assertEquals((Object)instanceId, (Object)deserialized.getConfiguration().getInstanceId());
        Assert.assertEquals((Object)tableId, (Object)deserialized.getConfiguration().getTableId());
        Assert.assertEquals((Object)startKey, (Object)ByteString.copyFrom((byte[])((Scan)deserialized.getConfiguration().getScanValueProvider().get()).getStartRow()).toStringUtf8());
        Assert.assertEquals((Object)endKey, (Object)ByteString.copyFrom((byte[])((Scan)deserialized.getConfiguration().getScanValueProvider().get()).getStopRow()).toStringUtf8());
        Assert.assertEquals((long)estimatedSize, (long)deserialized.getEstimatedSize());
    }
}

