/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam;

import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.cloud.bigtable.beam.CloudBigtableScanConfiguration;
import java.io.Serializable;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.hadoop.hbase.client.Scan;
import org.junit.Assert;
import org.junit.Test;

public class CloudBigtableScanConfigurationTest {
    public static final String PROJECT = "project";
    public static final String INSTANCE = "instance";
    public static final String TABLE = "table";
    public static final byte[] START_ROW = "aa".getBytes();
    public static final byte[] STOP_ROW = "zz".getBytes();
    private static final CloudBigtableScanConfiguration config = new CloudBigtableScanConfiguration.Builder().withProjectId("project").withInstanceId("instance").withTableId("table").withScan(new Scan(START_ROW, STOP_ROW)).build();

    @Test
    public void testSerialization() {
        CloudBigtableScanConfiguration serialized = (CloudBigtableScanConfiguration)SerializableUtils.ensureSerializable((Serializable)config);
        Assert.assertEquals((Object)PROJECT, (Object)serialized.getProjectId());
        Assert.assertEquals((Object)INSTANCE, (Object)serialized.getInstanceId());
        Assert.assertEquals((Object)TABLE, (Object)serialized.getTableId());
        Assert.assertArrayEquals((byte[])START_ROW, (byte[])serialized.getStartRow());
        Assert.assertArrayEquals((byte[])STOP_ROW, (byte[])serialized.getStopRow());
    }

    @Test
    public void testEquals() {
        Scan scan1 = new Scan();
        Scan scan2 = new Scan(START_ROW, STOP_ROW);
        CloudBigtableScanConfiguration underTest1 = config.toBuilder().withScan(scan1).build();
        CloudBigtableScanConfiguration underTest2 = config.toBuilder().withScan(scan1).build();
        CloudBigtableScanConfiguration underTest3 = config.toBuilder().withScan(scan2).build();
        Assert.assertEquals((Object)underTest1, (Object)underTest2);
        Assert.assertNotEquals((Object)underTest1, (Object)underTest3);
    }

    @Test
    public void testToBuilder() {
        CloudBigtableScanConfiguration copy = config.toBuilder().build();
        Assert.assertNotSame((Object)config, (Object)copy);
        Assert.assertEquals((Object)config, (Object)copy);
    }

    @Test
    public void testRegularAndRuntimeParametersAreEqualWithScan() {
        CloudBigtableScanConfiguration withRegularParameters = config.toBuilder().withConfiguration("somekey", "somevalue").build();
        CloudBigtableScanConfiguration withRuntimeParameters = new CloudBigtableScanConfiguration.Builder().withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)TABLE)).withProjectId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)PROJECT)).withInstanceId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)INSTANCE)).withScan(new Scan(START_ROW, STOP_ROW)).withConfiguration("somekey", (ValueProvider)ValueProvider.StaticValueProvider.of((Object)"somevalue")).build();
        Assert.assertEquals((Object)withRegularParameters, (Object)withRuntimeParameters);
        ReadRowsRequest request = withRegularParameters.getRequest();
        withRegularParameters = withRegularParameters.toBuilder().withRequest(request).build();
        withRuntimeParameters = withRuntimeParameters.toBuilder().withRequest((ValueProvider)ValueProvider.StaticValueProvider.of((Object)request)).build();
        Assert.assertEquals((Object)withRegularParameters, (Object)withRuntimeParameters);
    }

    @Test
    public void testRegularAndRuntimeParametersAreEqualWithRequest() {
        ReadRowsRequest request = ReadRowsRequest.newBuilder().setRowsLimit(10L).build();
        CloudBigtableScanConfiguration withRegularParameters = config.toBuilder().withRequest(request).withKeys(START_ROW, STOP_ROW).withConfiguration("somekey", "somevalue").build();
        CloudBigtableScanConfiguration withRuntimeParameters = new CloudBigtableScanConfiguration.Builder().withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)TABLE)).withProjectId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)PROJECT)).withInstanceId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)INSTANCE)).withRequest((ValueProvider)ValueProvider.StaticValueProvider.of((Object)request)).withKeys(START_ROW, STOP_ROW).withConfiguration("somekey", (ValueProvider)ValueProvider.StaticValueProvider.of((Object)"somevalue")).build();
        Assert.assertEquals((Object)withRegularParameters, (Object)withRuntimeParameters);
        ReadRowsRequest updatedRequest = withRegularParameters.getRequest();
        withRegularParameters = withRegularParameters.toBuilder().withRequest(updatedRequest).build();
        withRuntimeParameters = withRuntimeParameters.toBuilder().withRequest((ValueProvider)ValueProvider.StaticValueProvider.of((Object)updatedRequest)).build();
        Assert.assertEquals((Object)withRegularParameters, (Object)withRuntimeParameters);
    }
}

