/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam;

import com.google.cloud.bigtable.beam.CloudBigtableConfiguration;
import com.google.cloud.bigtable.beam.CloudBigtableTableConfiguration;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CloudBigtableTableConfigurationTest {
    private static final String PROJECT = "my_project";
    private static final String INSTANCE = "instance";
    private static final String TABLE = "some-zone-1a";

    protected static CloudBigtableTableConfiguration buildConfiguration() {
        return CloudBigtableTableConfigurationTest.configure(new CloudBigtableTableConfiguration.Builder().withTableId(TABLE)).build();
    }

    protected static <ConfigurationBuilder extends CloudBigtableConfiguration.Builder> ConfigurationBuilder configure(ConfigurationBuilder builder) {
        builder.withProjectId(PROJECT).withInstanceId(INSTANCE);
        return builder;
    }

    @Test
    public void testHBaseConfig() {
        CloudBigtableTableConfiguration underTest = CloudBigtableTableConfigurationTest.buildConfiguration();
        Configuration config = underTest.toHBaseConfig();
        Assert.assertEquals((Object)PROJECT, (Object)config.get("google.bigtable.project.id"));
        Assert.assertEquals((Object)INSTANCE, (Object)config.get("google.bigtable.instance.id"));
        Assert.assertEquals((Object)TABLE, (Object)underTest.getTableId());
    }

    @Test
    public void testEquals() {
        CloudBigtableTableConfiguration underTest1 = CloudBigtableTableConfigurationTest.buildConfiguration();
        CloudBigtableTableConfiguration underTest2 = CloudBigtableTableConfigurationTest.buildConfiguration();
        CloudBigtableTableConfiguration underTest3 = underTest1.toBuilder().withConfiguration("somekey", "somevalue").build();
        CloudBigtableTableConfiguration underTest4 = underTest1.toBuilder().withProjectId("other_project").build();
        CloudBigtableConfiguration underTest5 = CloudBigtableTableConfigurationTest.configure(new CloudBigtableConfiguration.Builder()).build();
        Assert.assertEquals((Object)underTest1, (Object)underTest2);
        Assert.assertNotEquals((Object)underTest1, (Object)underTest3);
        Assert.assertNotEquals((Object)underTest1, (Object)underTest4);
        Assert.assertNotEquals((Object)underTest1, (Object)underTest5);
        Assert.assertNotEquals((Object)underTest5, (Object)underTest1);
    }

    @Test
    public void testToBuilder() {
        CloudBigtableTableConfiguration underTest = CloudBigtableTableConfigurationTest.buildConfiguration().toBuilder().withConfiguration("somekey", "somevalue").build();
        CloudBigtableTableConfiguration copy = underTest.toBuilder().build();
        Assert.assertNotSame((Object)underTest, (Object)copy);
        Assert.assertEquals((Object)underTest, (Object)copy);
    }

    @Test
    public void testRegularAndRuntimeParametersAreEqual() {
        CloudBigtableTableConfiguration withRegularParameters = CloudBigtableTableConfigurationTest.buildConfiguration().toBuilder().withConfiguration("somekey", "somevalue").build();
        CloudBigtableTableConfiguration withRuntimeParameters = new CloudBigtableTableConfiguration.Builder().withTableId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)TABLE)).withProjectId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)PROJECT)).withInstanceId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)INSTANCE)).withConfiguration("somekey", (ValueProvider)ValueProvider.StaticValueProvider.of((Object)"somevalue")).build();
        Assert.assertNotSame((Object)withRegularParameters, (Object)withRuntimeParameters);
        Assert.assertEquals((Object)withRegularParameters, (Object)withRuntimeParameters);
    }
}

