/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam;

import com.google.cloud.bigtable.beam.CloudBigtableConfiguration;
import com.google.cloud.bigtable.hbase.BigtableConfiguration;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCloudBigtableTableDoFn<In, Out>
extends DoFn<In, Out> {
    private static final long serialVersionUID = 1L;
    protected final Logger DOFN_LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final CloudBigtableConfiguration config;
    protected Connection connection;

    public static void logRetriesExhaustedWithDetailsException(Logger log, String context, RetriesExhaustedWithDetailsException exception) {
        if (log.isDebugEnabled()) {
            log.error("For context {}: exception occurred during a bulk operation: {}", (Object)context, (Object)exception.getExhaustiveDescription());
        }
        if (exception.getNumExceptions() == 0) {
            log.error("For context {}: Got a RetriesExhaustedWithDetailsException without any details.", (Throwable)exception);
            return;
        }
        log.error(String.format("For context %s: %d exceptions occurred during a bulk operation:\n\t%s.\nThe stack trace is a sample exception, of the first exception.\nBreakdown of exceptions {type - count}: %s", context, exception.getNumExceptions(), exception.getMessage(), AbstractCloudBigtableTableDoFn.getFurtherInfo(exception)), exception.getCause(0));
    }

    private static Map<String, Integer> getFurtherInfo(RetriesExhaustedWithDetailsException exception) {
        TreeMap<String, Integer> furtherInfo = new TreeMap<String, Integer>();
        try {
            List causes = exception.getCauses();
            for (Throwable throwable : causes) {
                String message = throwable.getClass().getName() + ": " + throwable.getMessage();
                Integer count = (Integer)furtherInfo.get(message);
                if (count == null) {
                    furtherInfo.put(message, 1);
                    continue;
                }
                furtherInfo.put(message, 1 + count);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return furtherInfo;
    }

    protected static void rethrowException(RetriesExhaustedWithDetailsException exception) throws Exception {
        if (exception.getCauses().size() == 1) {
            throw (Exception)exception.getCause(0);
        }
        throw exception;
    }

    public AbstractCloudBigtableTableDoFn(CloudBigtableConfiguration config) {
        this.config = config;
    }

    @DoFn.Teardown
    public void cleanupConnection() throws IOException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    protected synchronized Connection getConnection() {
        if (this.connection == null) {
            this.connection = BigtableConfiguration.connect((Configuration)this.config.toHBaseConfig());
        }
        return this.connection;
    }

    protected void logExceptions(Object context, RetriesExhaustedWithDetailsException exception) {
        AbstractCloudBigtableTableDoFn.logRetriesExhaustedWithDetailsException(this.DOFN_LOG, String.valueOf(context), exception);
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        this.config.populateDisplayData(builder);
    }

    public CloudBigtableConfiguration getConfig() {
        return this.config;
    }
}

