/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.beam;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.bigtable.batch.common.CloudBigtableServiceImpl;
import com.google.cloud.bigtable.beam.AbstractCloudBigtableTableDoFn;
import com.google.cloud.bigtable.beam.CloudBigtableConfiguration;
import com.google.cloud.bigtable.beam.CloudBigtableScanConfiguration;
import com.google.cloud.bigtable.beam.CloudBigtableTableConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.io.range.ByteKeyRangeTracker;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class CloudBigtableIO {
    public static PTransform<PCollection<Mutation>, PDone> writeToTable(CloudBigtableTableConfiguration config) {
        CloudBigtableSingleTableBufferedWriteFn writeFn = new CloudBigtableSingleTableBufferedWriteFn(config);
        return new CloudBigtableWriteTransform<Mutation>(writeFn, config);
    }

    private static Coder<Result> getResultCoder() {
        try {
            return CoderRegistry.createDefault().getCoder(Result.class);
        }
        catch (CannotProvideCoderException e) {
            e.printStackTrace();
            throw new RuntimeException("Please add beam-sdks-java-io-hbase to your dependencies", e);
        }
    }

    public static PTransform<PCollection<KV<String, Iterable<Mutation>>>, PDone> writeToMultipleTables(CloudBigtableConfiguration config) {
        return new CloudBigtableWriteTransform<KV<String, Iterable<Mutation>>>(new CloudBigtableMultiTableWriteFn(config), config);
    }

    public static BoundedSource<Result> read(CloudBigtableScanConfiguration config) {
        return new Source(config);
    }

    private static class CloudBigtableWriteTransform<T>
    extends PTransform<PCollection<T>, PDone> {
        private static final long serialVersionUID = -2888060194257930027L;
        private final DoFn<T, Void> function;
        private final CloudBigtableConfiguration configuration;

        public CloudBigtableWriteTransform(DoFn<T, Void> function, CloudBigtableConfiguration configuration) {
            this.function = function;
            this.configuration = configuration;
        }

        public PDone expand(PCollection<T> input) {
            input.apply((PTransform)ParDo.of(this.function));
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void validate(PipelineOptions options) {
            this.configuration.validate();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.function.populateDisplayData(builder);
        }
    }

    @InternalExtensionOnly
    public static class CloudBigtableMultiTableWriteFn
    extends BufferedMutatorDoFn<KV<String, Iterable<Mutation>>> {
        private static final long serialVersionUID = 2L;
        private transient Map<String, BufferedMutator> mutators;

        public CloudBigtableMultiTableWriteFn(CloudBigtableConfiguration config) {
            super(config);
        }

        @DoFn.StartBundle
        public void startBundle() throws Exception {
            this.mutators = new HashMap<String, BufferedMutator>();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) throws Exception {
            KV element = (KV)context.element();
            BufferedMutator mutator = this.getMutator(context, (String)element.getKey());
            try {
                for (Mutation mutation : (Iterable)element.getValue()) {
                    mutator.mutate(mutation);
                    mutationsCounter.inc();
                }
            }
            catch (RetriesExhaustedWithDetailsException exception) {
                this.logExceptions(context, exception);
                CloudBigtableMultiTableWriteFn.rethrowException(exception);
            }
        }

        private BufferedMutator getMutator(Object context, String tableName) throws IOException {
            BufferedMutator mutator = this.mutators.get(tableName);
            if (mutator == null) {
                mutator = this.createBufferedMutator(context, tableName);
                this.mutators.put(tableName, mutator);
            }
            return mutator;
        }

        @DoFn.FinishBundle
        public void finishBundle(DoFn.FinishBundleContext c) throws Exception {
            for (BufferedMutator bufferedMutator : this.mutators.values()) {
                try {
                    bufferedMutator.flush();
                }
                catch (RetriesExhaustedWithDetailsException exception) {
                    this.logExceptions(c, exception);
                    CloudBigtableMultiTableWriteFn.rethrowException(exception);
                }
            }
            this.mutators.clear();
        }
    }

    @InternalExtensionOnly
    public static class CloudBigtableSingleTableBufferedWriteFn
    extends BufferedMutatorDoFn<Mutation> {
        private static final long serialVersionUID = 2L;
        private transient BufferedMutator mutator;

        public CloudBigtableSingleTableBufferedWriteFn(CloudBigtableTableConfiguration config) {
            super(config);
        }

        @DoFn.StartBundle
        public void setupBufferedMutator(DoFn.StartBundleContext context) throws IOException {
            this.mutator = this.createBufferedMutator(context, ((CloudBigtableTableConfiguration)this.getConfig()).getTableId());
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) throws Exception {
            Mutation mutation = (Mutation)context.element();
            if (this.DOFN_LOG.isTraceEnabled()) {
                this.DOFN_LOG.trace("Persisting {}", (Object)Bytes.toStringBinary((byte[])mutation.getRow()));
            }
            this.mutator.mutate(mutation);
            mutationsCounter.inc();
        }

        @DoFn.FinishBundle
        public synchronized void finishBundle(DoFn.FinishBundleContext context) throws Exception {
            try {
                if (this.mutator != null) {
                    this.mutator.close();
                    this.mutator = null;
                }
            }
            catch (RetriesExhaustedWithDetailsException exception) {
                exceptionsCounter.inc((long)exception.getCauses().size());
                this.logExceptions(null, exception);
                CloudBigtableSingleTableBufferedWriteFn.rethrowException(exception);
            }
        }
    }

    private static abstract class BufferedMutatorDoFn<InputType>
    extends AbstractCloudBigtableTableDoFn<InputType, Void> {
        private static final long serialVersionUID = 1L;
        protected static final Counter mutationsCounter = Metrics.counter(CloudBigtableIO.class, (String)"Mutations");
        protected static final Counter exceptionsCounter = Metrics.counter(CloudBigtableIO.class, (String)"Exceptions");
        protected static final Gauge cumulativeThrottlingSeconds = Metrics.gauge(CloudBigtableIO.class, (String)"ThrottlingSeconds");

        public BufferedMutatorDoFn(CloudBigtableConfiguration config) {
            super(config);
        }

        @DoFn.Setup
        public synchronized void setup() {
        }

        protected BufferedMutator createBufferedMutator(Object context, String tableName) throws IOException {
            return this.getConnection().getBufferedMutator(new BufferedMutatorParams(TableName.valueOf((String)tableName)).listener(this.createExceptionListener(context)));
        }

        protected BufferedMutator.ExceptionListener createExceptionListener(final Object context) {
            return new BufferedMutator.ExceptionListener(){

                public void onException(RetriesExhaustedWithDetailsException exception, BufferedMutator mutator) throws RetriesExhaustedWithDetailsException {
                    this.logExceptions(context, exception);
                    throw exception;
                }
            };
        }
    }

    @VisibleForTesting
    static class Reader
    extends BoundedSource.BoundedReader<Result> {
        private static final Logger READER_LOG = LoggerFactory.getLogger(Reader.class);
        private AbstractSource source;
        private transient Connection connection;
        private transient ResultScanner scanner;
        private transient Result current;
        protected long workStart;
        private final AtomicLong rowsRead = new AtomicLong();
        private final ByteKeyRangeTracker rangeTracker;

        @VisibleForTesting
        Reader(AbstractSource source) {
            this.source = source;
            this.rangeTracker = ByteKeyRangeTracker.of((ByteKeyRange)source.getConfiguration().toByteKeyRange());
        }

        public boolean start() throws IOException {
            this.initializeScanner();
            this.workStart = System.currentTimeMillis();
            return this.advance();
        }

        @VisibleForTesting
        void initializeScanner() throws IOException {
            Configuration config = this.source.getConfiguration().toHBaseConfig();
            this.connection = ConnectionFactory.createConnection((Configuration)config);
            Scan scan = new Scan().withStartRow(this.source.getConfiguration().getZeroCopyStartRow()).withStopRow(this.source.getConfiguration().getZeroCopyStopRow()).setMaxVersions(Integer.MAX_VALUE);
            this.scanner = this.connection.getTable(TableName.valueOf((String)this.source.getConfiguration().getTableId())).getScanner(scan);
        }

        public boolean advance() throws IOException {
            Result row = this.scanner.next();
            if (row != null && this.rangeTracker.tryReturnRecordAt(true, ByteKey.copyFrom((byte[])row.getRow()))) {
                this.current = row;
                this.rowsRead.addAndGet(1L);
                return true;
            }
            this.current = null;
            this.rangeTracker.markDone();
            return false;
        }

        public final Double getFractionConsumed() {
            if (this.rangeTracker.isDone()) {
                return 1.0;
            }
            return this.rangeTracker.getFractionConsumed();
        }

        public final synchronized BoundedSource<Result> splitAtFraction(double fraction) {
            ByteKey splitKey;
            if (fraction < 0.01 || fraction > 0.99) {
                return null;
            }
            try {
                splitKey = this.rangeTracker.getRange().interpolateKey(fraction);
            }
            catch (IllegalArgumentException e) {
                READER_LOG.info("{}: Failed to interpolate key for fraction {}.", (Object)this.rangeTracker.getRange(), (Object)fraction);
                return null;
            }
            READER_LOG.info("Proposing to split {} at fraction {} (key {})", new Object[]{this.rangeTracker, fraction, splitKey});
            long estimatedSizeBytes = -1L;
            try {
                estimatedSizeBytes = this.source.calculateEstimatedSizeBytes(null);
            }
            catch (IOException e) {
                READER_LOG.info("{}: Failed to get estimated size for key for fraction {}.", (Object)this.rangeTracker.getRange(), (Object)fraction);
                return null;
            }
            SourceWithKeys residual = null;
            SourceWithKeys primary = null;
            try {
                long newPrimarySize = (long)(fraction * (double)estimatedSizeBytes);
                long residualSize = estimatedSizeBytes - newPrimarySize;
                byte[] currentStartKey = this.rangeTracker.getRange().getStartKey().getBytes();
                byte[] splitKeyBytes = splitKey.getBytes();
                byte[] currentStopKey = this.rangeTracker.getRange().getEndKey().getBytes();
                if (!this.rangeTracker.trySplitAtPosition(splitKey)) {
                    return null;
                }
                primary = this.source.createSourceWithKeys(currentStartKey, splitKeyBytes, newPrimarySize);
                residual = this.source.createSourceWithKeys(splitKeyBytes, currentStopKey, residualSize);
                this.source = primary;
                return residual;
            }
            catch (Throwable t) {
                try {
                    String msg = String.format("%d Failed to get estimated size for key for fraction %f.", this.rangeTracker.getRange(), fraction);
                    READER_LOG.warn(msg, t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        }

        @VisibleForTesting
        protected void setConnection(Connection connection) {
            this.connection = connection;
        }

        @VisibleForTesting
        protected void setScanner(ResultScanner scanner) {
            this.scanner = scanner;
        }

        @VisibleForTesting
        public ByteKeyRangeTracker getRangeTracker() {
            return this.rangeTracker;
        }

        public void close() throws IOException {
            if (this.scanner != null) {
                this.scanner.close();
                this.scanner = null;
            }
            long totalOps = this.getRowsReadCount();
            long elapsedTimeMs = System.currentTimeMillis() - this.workStart;
            long operationsPerSecond = elapsedTimeMs == 0L ? 0L : totalOps * 1000L / elapsedTimeMs;
            READER_LOG.info("{} Complete: {} operations in {} ms. That's {} operations/sec", new Object[]{this, totalOps, elapsedTimeMs, operationsPerSecond});
        }

        @VisibleForTesting
        long getRowsReadCount() {
            return this.rowsRead.get();
        }

        public final Result getCurrent() throws NoSuchElementException {
            return this.current;
        }

        public final synchronized BoundedSource<Result> getCurrentSource() {
            return this.source;
        }

        public String toString() {
            return String.format("Reader for: ['%s' - '%s']", Bytes.toStringBinary((byte[])this.rangeTracker.getStartPosition().getBytes()), Bytes.toStringBinary((byte[])this.rangeTracker.getStopPosition().getBytes()));
        }
    }

    protected static class SourceWithKeys
    extends AbstractSource {
        private static final long serialVersionUID = 1L;
        private final long estimatedSize;

        protected SourceWithKeys(CloudBigtableScanConfiguration configuration, long estimatedSize) {
            super(configuration);
            byte[] stopRow = configuration.getZeroCopyStopRow();
            if (stopRow.length > 0) {
                byte[] startRow = configuration.getZeroCopyStartRow();
                if (Bytes.compareTo((byte[])startRow, (byte[])stopRow) >= 0) {
                    throw new IllegalArgumentException(String.format("Source keys not in order: [%s, %s]", Bytes.toStringBinary((byte[])startRow), Bytes.toStringBinary((byte[])stopRow)));
                }
                Preconditions.checkState((estimatedSize >= 0L ? 1 : 0) != 0, (String)"Source size cannot be negative", (long)estimatedSize);
            }
            this.estimatedSize = estimatedSize;
            SOURCE_LOG.debug("Source with split: {}.", (Object)this);
        }

        @Override
        protected long calculateEstimatedSizeBytes(PipelineOptions options) throws IOException {
            return this.estimatedSize;
        }

        public long getEstimatedSize() {
            return this.estimatedSize;
        }

        public List<? extends BoundedSource<Result>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
            CloudBigtableScanConfiguration conf = this.getConfiguration();
            List<SourceWithKeys> newSplits = this.split(this.estimatedSize, desiredBundleSizeBytes, conf.getZeroCopyStartRow(), conf.getZeroCopyStopRow());
            SOURCE_LOG.trace("Splitting split {} into {}", (Object)this, newSplits);
            return newSplits;
        }

        @Override
        public Coder<Result> getOutputCoder() {
            return CloudBigtableIO.getResultCoder();
        }

        public String toString() {
            return String.format("Split start: '%s', end: '%s', size: %d.", Bytes.toStringBinary((byte[])this.getConfiguration().getZeroCopyStartRow()), Bytes.toStringBinary((byte[])this.getConfiguration().getZeroCopyStopRow()), this.estimatedSize);
        }
    }

    @InternalExtensionOnly
    public static class Source
    extends AbstractSource {
        private static final long serialVersionUID = -5580115943635114126L;

        Source(CloudBigtableScanConfiguration configuration) {
            super(configuration);
        }

        public List<? extends BoundedSource<Result>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
            List<SourceWithKeys> splits = this.getSplits(desiredBundleSizeBytes);
            SOURCE_LOG.info("Creating {} splits.", (Object)splits.size());
            SOURCE_LOG.debug("Created splits {}.", splits);
            return splits;
        }

        @Override
        public Coder<Result> getOutputCoder() {
            return CloudBigtableIO.getResultCoder();
        }
    }

    @InternalExtensionOnly
    static abstract class AbstractSource
    extends BoundedSource<Result> {
        protected static final Logger SOURCE_LOG = LoggerFactory.getLogger(AbstractSource.class);
        protected static final long SIZED_BASED_MAX_SPLIT_COUNT = 4000L;
        static final long COUNT_MAX_SPLIT_COUNT = 15360L;
        private final CloudBigtableScanConfiguration configuration;
        private transient List<KeyOffset> sampleRowKeys;

        AbstractSource(CloudBigtableScanConfiguration configuration) {
            this.configuration = configuration;
        }

        public Coder<Result> getOutputCoder() {
            return CloudBigtableIO.getResultCoder();
        }

        protected List<SourceWithKeys> getSplits(long desiredBundleSizeBytes) throws Exception {
            desiredBundleSizeBytes = Math.max(this.calculateEstimatedSizeBytes(null) / 4000L, desiredBundleSizeBytes);
            CloudBigtableScanConfiguration conf = this.getConfiguration();
            byte[] scanStartKey = conf.getZeroCopyStartRow();
            byte[] scanEndKey = conf.getZeroCopyStopRow();
            ArrayList<SourceWithKeys> splits = new ArrayList<SourceWithKeys>();
            byte[] startKey = HConstants.EMPTY_START_ROW;
            long lastOffset = 0L;
            for (KeyOffset response : this.getSampleRowKeys()) {
                byte[] endKey = response.getKey().toByteArray();
                if (Bytes.equals((byte[])startKey, (byte[])endKey) && startKey.length > 0) continue;
                long offset = response.getOffsetBytes();
                if (AbstractSource.isWithinRange(scanStartKey, scanEndKey, startKey, endKey)) {
                    byte[] splitStart = null;
                    byte[] splitStop = null;
                    splitStart = scanStartKey.length == 0 || Bytes.compareTo((byte[])startKey, (byte[])scanStartKey) >= 0 ? startKey : scanStartKey;
                    splitStop = (scanEndKey.length == 0 || Bytes.compareTo((byte[])endKey, (byte[])scanEndKey) <= 0) && endKey.length > 0 ? endKey : scanEndKey;
                    splits.addAll(this.split(offset - lastOffset, desiredBundleSizeBytes, splitStart, splitStop));
                }
                lastOffset = offset;
                startKey = endKey;
            }
            byte[] endKey = HConstants.EMPTY_END_ROW;
            if (!Bytes.equals((byte[])startKey, (byte[])endKey) && scanEndKey.length == 0) {
                splits.add(this.createSourceWithKeys(startKey, endKey, 0L));
            }
            List<SourceWithKeys> result = this.reduceSplits(splits);
            Collections.shuffle(result);
            return result;
        }

        private List<SourceWithKeys> reduceSplits(List<SourceWithKeys> splits) {
            if ((long)splits.size() < 15360L) {
                return splits;
            }
            ArrayList<SourceWithKeys> reducedSplits = new ArrayList<SourceWithKeys>();
            AbstractSource start = null;
            AbstractSource lastSeen = null;
            int numberToCombine = (int)(((long)splits.size() + 15360L - 1L) / 15360L);
            int counter = 0;
            long size = 0L;
            for (SourceWithKeys source : splits) {
                if (counter == 0) {
                    start = source;
                }
                size += source.getEstimatedSize();
                lastSeen = source;
                if (++counter != numberToCombine) continue;
                reducedSplits.add(this.createSourceWithKeys(start.getConfiguration().getZeroCopyStartRow(), source.getConfiguration().getZeroCopyStopRow(), size));
                counter = 0;
                size = 0L;
                start = null;
            }
            if (start != null) {
                reducedSplits.add(this.createSourceWithKeys(start.getConfiguration().getZeroCopyStartRow(), lastSeen.getConfiguration().getZeroCopyStopRow(), size));
            }
            return reducedSplits;
        }

        protected static boolean isWithinRange(byte[] scanStartKey, byte[] scanEndKey, byte[] startKey, byte[] endKey) {
            return !(scanStartKey.length != 0 && endKey.length != 0 && Bytes.compareTo((byte[])scanStartKey, (byte[])endKey) >= 0 || scanEndKey.length != 0 && Bytes.compareTo((byte[])scanEndKey, (byte[])startKey) <= 0);
        }

        @InternalApi(value="For internal usage only")
        public synchronized List<KeyOffset> getSampleRowKeys() throws IOException {
            if (this.sampleRowKeys == null) {
                this.sampleRowKeys = new CloudBigtableServiceImpl().getSampleRowKeys(this.getConfiguration());
            }
            return this.sampleRowKeys;
        }

        @VisibleForTesting
        void setSampleRowKeys(List<KeyOffset> sampleRowKeys) {
            this.sampleRowKeys = sampleRowKeys;
        }

        public void validate() {
            this.getConfiguration().validate();
        }

        public long getEstimatedSizeBytes(PipelineOptions options) throws IOException {
            try {
                return this.calculateEstimatedSizeBytes(options);
            }
            catch (IllegalStateException e) {
                return 0L;
            }
        }

        protected long calculateEstimatedSizeBytes(PipelineOptions options) throws IOException {
            long totalEstimatedSizeBytes = 0L;
            byte[] scanStartKey = this.getConfiguration().getZeroCopyStartRow();
            byte[] scanStopKey = this.getConfiguration().getZeroCopyStopRow();
            byte[] startKey = HConstants.EMPTY_START_ROW;
            long lastOffset = 0L;
            for (KeyOffset response : this.getSampleRowKeys()) {
                byte[] currentEndKey = response.getKey().toByteArray();
                if (Bytes.equals((byte[])startKey, (byte[])currentEndKey) && startKey.length != 0) continue;
                long offset = response.getOffsetBytes();
                if (AbstractSource.isWithinRange(scanStartKey, scanStopKey, startKey, currentEndKey)) {
                    totalEstimatedSizeBytes += offset - lastOffset;
                }
                lastOffset = offset;
                startKey = currentEndKey;
            }
            SOURCE_LOG.info("Estimated size in bytes: " + totalEstimatedSizeBytes);
            return totalEstimatedSizeBytes;
        }

        protected List<SourceWithKeys> split(long regionSize, long desiredBundleSizeBytes, byte[] startKey, byte[] stopKey) throws IOException {
            Preconditions.checkState((desiredBundleSizeBytes >= 0L ? 1 : 0) != 0);
            int splitCount = (int)Math.ceil((double)regionSize / (double)desiredBundleSizeBytes);
            if (splitCount < 2 || stopKey.length == 0 || Bytes.compareTo((byte[])startKey, (byte[])stopKey) >= 0) {
                return Collections.singletonList(this.createSourceWithKeys(startKey, stopKey, regionSize));
            }
            if (stopKey.length > 0) {
                Preconditions.checkState((Bytes.compareTo((byte[])startKey, (byte[])stopKey) <= 0 ? 1 : 0) != 0, (String)"Source keys not in order: [%s, %s]", (Object)Bytes.toStringBinary((byte[])startKey), (Object)Bytes.toStringBinary((byte[])stopKey));
                Preconditions.checkState((regionSize > 0L ? 1 : 0) != 0, (String)"Source size must be positive", (long)regionSize);
            }
            try {
                byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])stopKey, (int)(splitCount - 1));
                Preconditions.checkState((splitCount + 1 == splitKeys.length ? 1 : 0) != 0);
                ArrayList<SourceWithKeys> result = new ArrayList<SourceWithKeys>();
                for (int i = 0; i < splitCount; ++i) {
                    result.add(this.createSourceWithKeys(splitKeys[i], splitKeys[i + 1], regionSize));
                }
                return result;
            }
            catch (Exception e) {
                SOURCE_LOG.warn(String.format("Could not split '%s' and '%s', so using that as a range.", Bytes.toString((byte[])startKey), Bytes.toString((byte[])stopKey)), (Throwable)e);
                return Collections.singletonList(this.createSourceWithKeys(startKey, stopKey, regionSize));
            }
        }

        @VisibleForTesting
        SourceWithKeys createSourceWithKeys(byte[] startKey, byte[] stopKey, long size) {
            CloudBigtableScanConfiguration updatedConfig = this.getConfiguration().toBuilder().withKeys(startKey, stopKey).build();
            return new SourceWithKeys(updatedConfig, size);
        }

        public BoundedSource.BoundedReader<Result> createReader(PipelineOptions options) {
            return new Reader(this);
        }

        protected CloudBigtableScanConfiguration getConfiguration() {
            return this.configuration;
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.configuration.populateDisplayData(builder);
        }
    }
}

