/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.client.auth.oauth;

import com.google.bigtable.repackaged.com.google.api.client.auth.oauth.OAuthSigner;
import com.google.bigtable.repackaged.com.google.api.client.http.GenericUrl;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpExecuteInterceptor;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpRequest;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.bigtable.repackaged.com.google.api.client.util.Beta;
import com.google.bigtable.repackaged.com.google.api.client.util.escape.PercentEscaper;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class OAuthParameters
implements HttpExecuteInterceptor,
HttpRequestInitializer {
    private static final SecureRandom RANDOM = new SecureRandom();
    public OAuthSigner signer;
    public String callback;
    public String consumerKey;
    public String nonce;
    public String realm;
    public String signature;
    public String signatureMethod;
    public String timestamp;
    public String token;
    public String verifier;
    public String version;
    private static final PercentEscaper ESCAPER = new PercentEscaper("-_.~", false);

    public void computeNonce() {
        this.nonce = Long.toHexString(Math.abs(RANDOM.nextLong()));
    }

    public void computeTimestamp() {
        this.timestamp = Long.toString(System.currentTimeMillis() / 1000L);
    }

    public void computeSignature(String requestMethod, GenericUrl requestUrl) throws GeneralSecurityException {
        OAuthSigner signer = this.signer;
        String signatureMethod = this.signatureMethod = signer.getSignatureMethod();
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        this.putParameterIfValueNotNull(parameters, "oauth_callback", this.callback);
        this.putParameterIfValueNotNull(parameters, "oauth_consumer_key", this.consumerKey);
        this.putParameterIfValueNotNull(parameters, "oauth_nonce", this.nonce);
        this.putParameterIfValueNotNull(parameters, "oauth_signature_method", signatureMethod);
        this.putParameterIfValueNotNull(parameters, "oauth_timestamp", this.timestamp);
        this.putParameterIfValueNotNull(parameters, "oauth_token", this.token);
        this.putParameterIfValueNotNull(parameters, "oauth_verifier", this.verifier);
        this.putParameterIfValueNotNull(parameters, "oauth_version", this.version);
        for (Map.Entry<String, Object> fieldEntry : requestUrl.entrySet()) {
            Object value = fieldEntry.getValue();
            if (value == null) continue;
            String name = fieldEntry.getKey();
            if (value instanceof Collection) {
                for (Object repeatedValue : (Collection)value) {
                    this.putParameter(parameters, name, repeatedValue);
                }
                continue;
            }
            this.putParameter(parameters, name, value);
        }
        StringBuilder parametersBuf = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (first) {
                first = false;
            } else {
                parametersBuf.append('&');
            }
            parametersBuf.append(entry.getKey());
            String value = entry.getValue();
            if (value == null) continue;
            parametersBuf.append('=').append(value);
        }
        String normalizedParameters = parametersBuf.toString();
        GenericUrl normalized = new GenericUrl();
        String scheme = requestUrl.getScheme();
        normalized.setScheme(scheme);
        normalized.setHost(requestUrl.getHost());
        normalized.setPathParts(requestUrl.getPathParts());
        int port = requestUrl.getPort();
        if ("http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443) {
            port = -1;
        }
        normalized.setPort(port);
        String normalizedPath = normalized.build();
        StringBuilder buf = new StringBuilder();
        buf.append(OAuthParameters.escape(requestMethod)).append('&');
        buf.append(OAuthParameters.escape(normalizedPath)).append('&');
        buf.append(OAuthParameters.escape(normalizedParameters));
        String signatureBaseString = buf.toString();
        this.signature = signer.computeSignature(signatureBaseString);
    }

    public String getAuthorizationHeader() {
        StringBuilder buf = new StringBuilder("OAuth");
        this.appendParameter(buf, "realm", this.realm);
        this.appendParameter(buf, "oauth_callback", this.callback);
        this.appendParameter(buf, "oauth_consumer_key", this.consumerKey);
        this.appendParameter(buf, "oauth_nonce", this.nonce);
        this.appendParameter(buf, "oauth_signature", this.signature);
        this.appendParameter(buf, "oauth_signature_method", this.signatureMethod);
        this.appendParameter(buf, "oauth_timestamp", this.timestamp);
        this.appendParameter(buf, "oauth_token", this.token);
        this.appendParameter(buf, "oauth_verifier", this.verifier);
        this.appendParameter(buf, "oauth_version", this.version);
        return buf.substring(0, buf.length() - 1);
    }

    private void appendParameter(StringBuilder buf, String name, String value) {
        if (value != null) {
            buf.append(' ').append(OAuthParameters.escape(name)).append("=\"").append(OAuthParameters.escape(value)).append("\",");
        }
    }

    private void putParameterIfValueNotNull(TreeMap<String, String> parameters, String key, String value) {
        if (value != null) {
            this.putParameter(parameters, key, value);
        }
    }

    private void putParameter(TreeMap<String, String> parameters, String key, Object value) {
        parameters.put(OAuthParameters.escape(key), value == null ? null : OAuthParameters.escape(value.toString()));
    }

    public static String escape(String value) {
        return ESCAPER.escape(value);
    }

    @Override
    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor(this);
    }

    @Override
    public void intercept(HttpRequest request) throws IOException {
        this.computeNonce();
        this.computeTimestamp();
        try {
            this.computeSignature(request.getRequestMethod(), request.getUrl());
        }
        catch (GeneralSecurityException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
        request.getHeaders().setAuthorization(this.getAuthorizationHeader());
    }
}

