/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.auth.appengine;

import com.google.appengine.api.appidentity.AppIdentityService;
import com.google.appengine.api.appidentity.AppIdentityServiceFactory;
import com.google.bigtable.repackaged.com.google.auth.oauth2.AccessToken;
import com.google.bigtable.repackaged.com.google.auth.oauth2.GoogleCredentials;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppEngineCredentials
extends GoogleCredentials {
    private final AppIdentityService appIdentityService;
    private final Collection<String> scopes;
    private final boolean scopesRequired;

    public AppEngineCredentials(Collection<String> scopes) {
        this(scopes, null);
    }

    public AppEngineCredentials(Collection<String> scopes, AppIdentityService appIdentityService) {
        this.scopes = ImmutableList.copyOf(scopes);
        this.appIdentityService = appIdentityService != null ? appIdentityService : AppIdentityServiceFactory.getAppIdentityService();
        this.scopesRequired = scopes == null || scopes.isEmpty();
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        if (this.createScopedRequired()) {
            throw new IOException("AppEngineCredentials requires createScoped call before use.");
        }
        AppIdentityService.GetAccessTokenResult accessTokenResponse = this.appIdentityService.getAccessToken(this.scopes);
        String accessToken = accessTokenResponse.getAccessToken();
        Date expirationTime = accessTokenResponse.getExpirationTime();
        return new AccessToken(accessToken, expirationTime);
    }

    @Override
    public boolean createScopedRequired() {
        return this.scopesRequired;
    }

    @Override
    public GoogleCredentials createScoped(Collection<String> scopes) {
        return new AppEngineCredentials(scopes, this.appIdentityService);
    }
}

