/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.auth.oauth2;

import com.google.bigtable.repackaged.com.google.api.client.json.JsonFactory;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonParser;
import com.google.bigtable.repackaged.com.google.auth.oauth2.AccessToken;
import com.google.bigtable.repackaged.com.google.auth.oauth2.GoogleCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.OAuth2Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class CloudShellCredentials
extends GoogleCredentials {
    private static final int ACCESS_TOKEN_INDEX = 2;
    private static final int READ_TIMEOUT_MS = 5000;
    protected static final String GET_AUTH_TOKEN_REQUEST = "2\n[]";
    private final int authPort;
    private final JsonFactory jsonFactory;

    public CloudShellCredentials(int authPort) {
        this.authPort = authPort;
        this.jsonFactory = OAuth2Utils.JSON_FACTORY;
    }

    protected int getAuthPort() {
        return this.authPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessToken refreshAccessToken() throws IOException {
        AccessToken token;
        Socket socket = new Socket("localhost", this.getAuthPort());
        socket.setSoTimeout(5000);
        try {
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            out.println(GET_AUTH_TOKEN_REQUEST);
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            input.readLine();
            JsonParser parser = this.jsonFactory.createJsonParser(input);
            List messageArray = (List)parser.parseArray(ArrayList.class, Object.class);
            String accessToken = messageArray.get(2).toString();
            token = new AccessToken(accessToken, null);
        }
        finally {
            socket.close();
        }
        return token;
    }
}

