/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.auth.oauth2;

import com.google.bigtable.repackaged.com.google.api.client.http.HttpTransport;
import com.google.bigtable.repackaged.com.google.auth.oauth2.CloudShellCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.GoogleCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.OAuth2Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultCredentialsProvider {
    static final String CREDENTIAL_ENV_VAR = "GOOGLE_APPLICATION_CREDENTIALS";
    static final String WELL_KNOWN_CREDENTIALS_FILE = "application_default_credentials.json";
    static final String CLOUDSDK_CONFIG_DIRECTORY = "gcloud";
    static final String HELP_PERMALINK = "https://developers.google.com/accounts/docs/application-default-credentials";
    static final String APP_ENGINE_CREDENTIAL_CLASS = "com.google.bigtable.repackaged.com.google.auth.appengine.AppEngineCredentials";
    static final String APP_ENGINE_SIGNAL_CLASS = "com.google.appengine.api.utils.SystemProperty";
    static final String CLOUD_SHELL_ENV_VAR = "DEVSHELL_CLIENT_PORT";
    private GoogleCredentials cachedCredentials = null;
    private boolean checkedAppEngine = false;
    private boolean checkedComputeEngine = false;

    DefaultCredentialsProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final GoogleCredentials getDefaultCredentials(HttpTransport transport) throws IOException {
        DefaultCredentialsProvider defaultCredentialsProvider = this;
        synchronized (defaultCredentialsProvider) {
            if (this.cachedCredentials == null) {
                this.cachedCredentials = this.getDefaultCredentialsUnsynchronized(transport);
            }
            if (this.cachedCredentials != null) {
                return this.cachedCredentials;
            }
        }
        throw new IOException(String.format("The Application Default Credentials are not available. They are available if running in Google Compute Engine. Otherwise, the environment variable %s must be defined pointing to a file defining the credentials. See %s for more information.", CREDENTIAL_ENV_VAR, HELP_PERMALINK));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GoogleCredentials getDefaultCredentialsUnsynchronized(HttpTransport transport) throws IOException {
        GoogleCredentials credentials = null;
        String credentialsPath = this.getEnv(CREDENTIAL_ENV_VAR);
        if (credentialsPath != null && credentialsPath.length() > 0) {
            InputStream credentialsStream = null;
            try {
                File credentialsFile = new File(credentialsPath);
                if (!this.isFile(credentialsFile)) {
                    throw new IOException("File does not exist.");
                }
                credentialsStream = this.readStream(credentialsFile);
                credentials = GoogleCredentials.fromStream(credentialsStream, transport);
            }
            catch (IOException e) {
                throw OAuth2Utils.exceptionWithCause(new IOException(String.format("Error reading credential file from environment variable %s, value '%s': %s", CREDENTIAL_ENV_VAR, credentialsPath, e.getMessage())), e);
            }
            catch (AccessControlException e) {
            }
            finally {
                if (credentialsStream != null) {
                    credentialsStream.close();
                }
            }
        }
        if (credentials == null) {
            File wellKnownFileLocation = this.getWellKnownCredentialsFile();
            InputStream credentialsStream = null;
            try {
                if (this.isFile(wellKnownFileLocation)) {
                    credentialsStream = this.readStream(wellKnownFileLocation);
                    credentials = GoogleCredentials.fromStream(credentialsStream, transport);
                }
            }
            catch (IOException e) {
                throw new IOException(String.format("Error reading credential file from location %s: %s", wellKnownFileLocation, e.getMessage()));
            }
            catch (AccessControlException accessControlException) {
            }
            finally {
                if (credentialsStream != null) {
                    credentialsStream.close();
                }
            }
        }
        if (credentials == null) {
            credentials = this.tryGetAppEngineCredential();
        }
        if (credentials == null) {
            credentials = this.tryGetCloudShellCredentials();
        }
        if (credentials == null) {
            credentials = this.tryGetComputeCredentials(transport);
        }
        return credentials;
    }

    private final File getWellKnownCredentialsFile() {
        File cloudConfigPath = null;
        String os = this.getProperty("os.name", "").toLowerCase(Locale.US);
        if (os.indexOf("windows") >= 0) {
            File appDataPath = new File(this.getEnv("APPDATA"));
            cloudConfigPath = new File(appDataPath, CLOUDSDK_CONFIG_DIRECTORY);
        } else {
            File configPath = new File(this.getProperty("user.home", ""), ".config");
            cloudConfigPath = new File(configPath, CLOUDSDK_CONFIG_DIRECTORY);
        }
        File credentialFilePath = new File(cloudConfigPath, WELL_KNOWN_CREDENTIALS_FILE);
        return credentialFilePath;
    }

    private boolean runningOnAppEngine() {
        Class<?> systemPropertyClass = null;
        try {
            systemPropertyClass = this.forName(APP_ENGINE_SIGNAL_CLASS);
        }
        catch (ClassNotFoundException expected) {
            return false;
        }
        Exception cause = null;
        try {
            Field environmentField = systemPropertyClass.getField("environment");
            Object environmentValue = environmentField.get(null);
            Class<?> environmentType = environmentField.getType();
            Method valueMethod = environmentType.getMethod("value", new Class[0]);
            Object environmentValueValue = valueMethod.invoke(environmentValue, new Object[0]);
            return environmentValueValue != null;
        }
        catch (NoSuchFieldException exception) {
            cause = exception;
        }
        catch (SecurityException exception) {
            cause = exception;
        }
        catch (IllegalArgumentException exception) {
            cause = exception;
        }
        catch (IllegalAccessException exception) {
            cause = exception;
        }
        catch (NoSuchMethodException exception) {
            cause = exception;
        }
        catch (InvocationTargetException exception) {
            cause = exception;
        }
        throw OAuth2Utils.exceptionWithCause(new RuntimeException(String.format("Unexpcted error trying to determine if runnning on Google App Engine: %s", cause.getMessage())), cause);
    }

    private GoogleCredentials tryGetCloudShellCredentials() {
        String port = this.getEnv(CLOUD_SHELL_ENV_VAR);
        if (port != null) {
            return new CloudShellCredentials(Integer.parseInt(port));
        }
        return null;
    }

    private GoogleCredentials tryGetAppEngineCredential() throws IOException {
        if (this.checkedAppEngine) {
            return null;
        }
        boolean onAppEngine = this.runningOnAppEngine();
        this.checkedAppEngine = true;
        if (!onAppEngine) {
            return null;
        }
        ReflectiveOperationException innerException = null;
        try {
            Class<?> credentialClass = this.forName(APP_ENGINE_CREDENTIAL_CLASS);
            Constructor<?> constructor = credentialClass.getConstructor(Collection.class);
            List emptyScopes = Collections.emptyList();
            return (GoogleCredentials)constructor.newInstance(emptyScopes);
        }
        catch (ClassNotFoundException e) {
            innerException = e;
        }
        catch (NoSuchMethodException e) {
            innerException = e;
        }
        catch (InstantiationException e) {
            innerException = e;
        }
        catch (IllegalAccessException e) {
            innerException = e;
        }
        catch (InvocationTargetException e) {
            innerException = e;
        }
        throw OAuth2Utils.exceptionWithCause(new IOException(String.format("Application Default Credentials failed to create the Google App Engine service account credentials class %s. Check that the component 'google-auth-library-appengine' is deployed.", APP_ENGINE_CREDENTIAL_CLASS)), innerException);
    }

    private final GoogleCredentials tryGetComputeCredentials(HttpTransport transport) {
        if (this.checkedComputeEngine) {
            return null;
        }
        boolean runningOnComputeEngine = ComputeEngineCredentials.runningOnComputeEngine(transport);
        this.checkedComputeEngine = true;
        if (runningOnComputeEngine) {
            return new ComputeEngineCredentials(transport);
        }
        return null;
    }

    Class<?> forName(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    String getEnv(String name) {
        return System.getenv(name);
    }

    String getProperty(String property, String def) {
        return System.getProperty(property, def);
    }

    boolean isFile(File file) {
        return file.isFile();
    }

    InputStream readStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }
}

