/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.config;

import com.google.bigtable.repackaged.com.google.cloud.config.BulkOptions;
import com.google.bigtable.repackaged.com.google.cloud.config.CallOptionsConfig;
import com.google.bigtable.repackaged.com.google.cloud.config.CredentialOptions;
import com.google.bigtable.repackaged.com.google.cloud.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableInstanceName;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Objects;

public class BigtableOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BIGTABLE_TABLE_ADMIN_HOST_DEFAULT = "bigtableadmin.googleapis.com";
    public static final String BIGTABLE_INSTANCE_ADMIN_HOST_DEFAULT = "bigtableadmin.googleapis.com";
    public static final String BIGTABLE_DATA_HOST_DEFAULT = "bigtable.googleapis.com";
    public static final int BIGTABLE_PORT_DEFAULT = 443;
    public static final int BIGTABLE_DATA_CHANNEL_COUNT_DEFAULT = BigtableOptions.getDefaultDataChannelCount();
    private static final Logger LOG = new Logger(BigtableOptions.class);
    private final String instanceAdminHost;
    private final String tableAdminHost;
    private final String dataHost;
    private final int port;
    private final String projectId;
    private final String instanceId;
    private final String userAgent;
    private final int dataChannelCount;
    private final boolean usePlaintextNegotiation;
    private final BigtableInstanceName instanceName;
    private final BulkOptions bulkOptions;
    private final CallOptionsConfig callOptionsConfig;
    private final CredentialOptions credentialOptions;
    private final RetryOptions retryOptions;

    private static int getDefaultDataChannelCount() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        return (int)Math.min(250.0, Math.max(1.0, Math.ceil((double)availableProcessors * 2.5)));
    }

    @VisibleForTesting
    BigtableOptions() {
        this.instanceAdminHost = null;
        this.tableAdminHost = null;
        this.dataHost = null;
        this.port = 0;
        this.projectId = null;
        this.instanceId = null;
        this.userAgent = null;
        this.dataChannelCount = 1;
        this.instanceName = null;
        this.usePlaintextNegotiation = false;
        this.bulkOptions = null;
        this.callOptionsConfig = null;
        this.credentialOptions = null;
        this.retryOptions = null;
    }

    private BigtableOptions(String instanceAdminHost, String tableAdminHost, String dataHost, int port, String projectId, String instanceId, String userAgent, boolean usePlaintextNegotiation, int channelCount, BulkOptions bulkOptions, CallOptionsConfig callOptionsConfig, CredentialOptions credentialOptions, RetryOptions retryOptions) {
        Preconditions.checkArgument(channelCount > 0, "Channel count has to be at least 1.");
        this.tableAdminHost = Preconditions.checkNotNull(tableAdminHost);
        this.instanceAdminHost = Preconditions.checkNotNull(instanceAdminHost);
        this.dataHost = Preconditions.checkNotNull(dataHost);
        this.port = port;
        this.projectId = projectId;
        this.instanceId = instanceId;
        this.credentialOptions = credentialOptions;
        this.userAgent = userAgent;
        this.retryOptions = retryOptions;
        this.dataChannelCount = channelCount;
        this.bulkOptions = bulkOptions;
        this.usePlaintextNegotiation = usePlaintextNegotiation;
        this.callOptionsConfig = callOptionsConfig;
        this.instanceName = !Strings.isNullOrEmpty(projectId) && !Strings.isNullOrEmpty(instanceId) ? new BigtableInstanceName(projectId, instanceId) : null;
        LOG.debug("Connection Configuration: projectId: %s, instanceId: %s, data host %s, table admin host %s, cluster admin host %s.", projectId, instanceId, dataHost, tableAdminHost, instanceAdminHost);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getDataHost() {
        return this.dataHost;
    }

    public String getTableAdminHost() {
        return this.tableAdminHost;
    }

    public String getInstanceAdminHost() {
        return this.instanceAdminHost;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public int getPort() {
        return this.port;
    }

    public CredentialOptions getCredentialOptions() {
        return this.credentialOptions;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public int getChannelCount() {
        return this.dataChannelCount;
    }

    public BigtableInstanceName getInstanceName() {
        return this.instanceName;
    }

    public BulkOptions getBulkOptions() {
        return this.bulkOptions;
    }

    public boolean usePlaintextNegotiation() {
        return this.usePlaintextNegotiation;
    }

    public CallOptionsConfig getCallOptionsConfig() {
        return this.callOptionsConfig;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != BigtableOptions.class) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BigtableOptions other = (BigtableOptions)obj;
        return this.port == other.port && this.dataChannelCount == other.dataChannelCount && this.usePlaintextNegotiation == other.usePlaintextNegotiation && Objects.equals(this.instanceAdminHost, other.instanceAdminHost) && Objects.equals(this.tableAdminHost, other.tableAdminHost) && Objects.equals(this.dataHost, other.dataHost) && Objects.equals(this.projectId, other.projectId) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.userAgent, other.userAgent) && Objects.equals(this.credentialOptions, other.credentialOptions) && Objects.equals(this.retryOptions, other.retryOptions) && Objects.equals(this.bulkOptions, other.bulkOptions) && Objects.equals(this.callOptionsConfig, other.callOptionsConfig);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("dataHost", this.dataHost).add("tableAdminHost", this.tableAdminHost).add("instanceAdminHost", this.instanceAdminHost).add("projectId", this.projectId).add("instanceId", this.instanceId).add("userAgent", this.userAgent).add("credentialType", (Object)this.credentialOptions.getCredentialType()).add("port", this.port).add("dataChannelCount", this.dataChannelCount).add("retryOptions", this.retryOptions).add("bulkOptions", this.bulkOptions).add("callOptionsConfig", this.callOptionsConfig).add("usePlaintextNegotiation", this.usePlaintextNegotiation).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String projectId;
        private String userAgent;
        private String instanceId;
        private String dataHost = "bigtable.googleapis.com";
        private String tableAdminHost = "bigtableadmin.googleapis.com";
        private String instanceAdminHost = "bigtableadmin.googleapis.com";
        private int port = 443;
        private int dataChannelCount = BIGTABLE_DATA_CHANNEL_COUNT_DEFAULT;
        private BulkOptions bulkOptions;
        private boolean usePlaintextNegotiation = false;
        private RetryOptions retryOptions = new RetryOptions.Builder().build();
        private CallOptionsConfig callOptionsConfig = new CallOptionsConfig.Builder().build();
        private CredentialOptions credentialOptions = CredentialOptions.defaultCredentials();

        public Builder() {
        }

        private Builder(BigtableOptions original) {
            this.projectId = original.projectId;
            this.instanceId = original.instanceId;
            this.userAgent = original.userAgent;
            this.dataHost = original.dataHost;
            this.tableAdminHost = original.tableAdminHost;
            this.instanceAdminHost = original.instanceAdminHost;
            this.port = original.port;
            this.credentialOptions = original.credentialOptions;
            this.retryOptions = original.retryOptions;
            this.dataChannelCount = original.dataChannelCount;
            this.bulkOptions = original.bulkOptions;
            this.usePlaintextNegotiation = original.usePlaintextNegotiation;
            this.callOptionsConfig = original.callOptionsConfig;
        }

        public Builder setTableAdminHost(String tableAdminHost) {
            this.tableAdminHost = tableAdminHost;
            return this;
        }

        public Builder setInstanceAdminHost(String instanceAdminHost) {
            this.instanceAdminHost = instanceAdminHost;
            return this;
        }

        public Builder setDataHost(String dataHost) {
            this.dataHost = dataHost;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder setCredentialOptions(CredentialOptions credentialOptions) {
            this.credentialOptions = credentialOptions;
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder setDataChannelCount(int dataChannelCount) {
            this.dataChannelCount = dataChannelCount;
            return this;
        }

        public int getDataChannelCount() {
            return this.dataChannelCount;
        }

        public Builder setRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public Builder setBulkOptions(BulkOptions bulkOptions) {
            this.bulkOptions = bulkOptions;
            return this;
        }

        public Builder setUsePlaintextNegotiation(boolean usePlaintextNegotiation) {
            this.usePlaintextNegotiation = usePlaintextNegotiation;
            return this;
        }

        public Builder setCallOptionsConfig(CallOptionsConfig callOptionsConfig) {
            this.callOptionsConfig = callOptionsConfig;
            return this;
        }

        public BigtableOptions build() {
            if (this.bulkOptions == null) {
                int maxInflightRpcs = 50 * this.dataChannelCount;
                this.bulkOptions = new BulkOptions.Builder().setMaxInflightRpcs(maxInflightRpcs).build();
            } else if (this.bulkOptions.getMaxInflightRpcs() <= 0) {
                int maxInflightRpcs = 50 * this.dataChannelCount;
                this.bulkOptions = this.bulkOptions.toBuilder().setMaxInflightRpcs(maxInflightRpcs).build();
            }
            return new BigtableOptions(this.instanceAdminHost, this.tableAdminHost, this.dataHost, this.port, this.projectId, this.instanceId, this.userAgent, this.usePlaintextNegotiation, this.dataChannelCount, this.bulkOptions, this.callOptionsConfig, this.credentialOptions, this.retryOptions);
        }
    }
}

