/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.config;

import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.io.Serializable;

public class CallOptionsConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean USE_TIMEOUT_DEFAULT = false;
    public static final int TIMEOUT_MS_DEFAULT = 60000;
    private final boolean useTimeout;
    private final int timeoutMs;

    public CallOptionsConfig(boolean useTimeout, int timeoutMs) {
        this.useTimeout = useTimeout;
        this.timeoutMs = timeoutMs;
    }

    public boolean isUseTimeout() {
        return this.useTimeout;
    }

    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != CallOptionsConfig.class) {
            return false;
        }
        CallOptionsConfig other = (CallOptionsConfig)obj;
        return this.useTimeout == other.useTimeout && this.timeoutMs == other.timeoutMs;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("useTimeout", this.useTimeout).add("timeoutMs", this.timeoutMs).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private boolean useTimeout = false;
        private int timeoutMs = 60000;

        public Builder() {
        }

        private Builder(CallOptionsConfig original) {
            this.useTimeout = original.useTimeout;
            this.timeoutMs = original.timeoutMs;
        }

        public Builder setUseTimeout(boolean useTimeout) {
            this.useTimeout = useTimeout;
            return this;
        }

        public Builder setTimeoutMs(int timeoutMs) {
            Preconditions.checkArgument(timeoutMs > 0, "Timeout ms has to be greater than 0");
            this.timeoutMs = timeoutMs;
            return this;
        }

        public CallOptionsConfig build() {
            return new CallOptionsConfig(this.useTimeout, this.timeoutMs);
        }
    }
}

