/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.grpc;

import com.google.bigtable.repackaged.com.google.cloud.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableDataClient;
import com.google.bigtable.repackaged.com.google.cloud.grpc.CallOptionsFactory;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.AbstractRetryingRpcListener;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.BigtableAsyncRpc;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.BigtableAsyncUtilities;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.RetryingCollectingClientCallListener;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.RetryingUnaryRpcListener;
import com.google.bigtable.repackaged.com.google.cloud.grpc.io.CancellationToken;
import com.google.bigtable.repackaged.com.google.cloud.grpc.io.ChannelPool;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.BigtableResultScannerFactory;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.ResponseQueueReader;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.ResultScanner;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.ResumingStreamingResultScanner;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.RowMerger;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.StreamObserverAdapter;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.StreamingBigtableResultScanner;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Mutation;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Function;
import com.google.bigtable.repackaged.com.google.common.base.Predicate;
import com.google.bigtable.repackaged.com.google.common.base.Predicates;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.protobuf.ServiceException;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;

public class BigtableDataGrpcClient
implements BigtableDataClient {
    private static final Metadata.Key<String> GRPC_RESOURCE_PREFIX_KEY = Metadata.Key.of("google-cloud-resource-prefix", Metadata.ASCII_STRING_MARSHALLER);
    private static final Logger LOG = new Logger(BigtableDataGrpcClient.class);
    @VisibleForTesting
    public static final Predicate<MutateRowRequest> IS_RETRYABLE_MUTATION = new Predicate<MutateRowRequest>(){

        @Override
        public boolean apply(MutateRowRequest mutateRowRequest) {
            return mutateRowRequest != null && BigtableDataGrpcClient.allCellsHaveTimestamps(mutateRowRequest.getMutationsList());
        }
    };
    @VisibleForTesting
    public static final Predicate<MutateRowsRequest> ARE_RETRYABLE_MUTATIONS = new Predicate<MutateRowsRequest>(){

        @Override
        public boolean apply(MutateRowsRequest mutateRowsRequest) {
            if (mutateRowsRequest == null) {
                return false;
            }
            for (MutateRowsRequest.Entry entry : mutateRowsRequest.getEntriesList()) {
                if (BigtableDataGrpcClient.allCellsHaveTimestamps(entry.getMutationsList())) continue;
                return false;
            }
            return true;
        }
    };
    @VisibleForTesting
    public static final Predicate<CheckAndMutateRowRequest> IS_RETRYABLE_CHECK_AND_MUTATE = new Predicate<CheckAndMutateRowRequest>(){

        @Override
        public boolean apply(CheckAndMutateRowRequest checkAndMutateRowRequest) {
            return checkAndMutateRowRequest != null && BigtableDataGrpcClient.allCellsHaveTimestamps(checkAndMutateRowRequest.getTrueMutationsList()) && BigtableDataGrpcClient.allCellsHaveTimestamps(checkAndMutateRowRequest.getFalseMutationsList());
        }
    };
    private static Function<List<ReadRowsResponse>, List<Row>> ROW_TRANSFORMER = new Function<List<ReadRowsResponse>, List<Row>>(){

        @Override
        public List<Row> apply(List<ReadRowsResponse> responses) {
            return RowMerger.toRows(responses);
        }
    };
    private final ChannelPool channelPool;
    private final ScheduledExecutorService retryExecutorService;
    private final RetryOptions retryOptions;
    private final BigtableOptions bigtableOptions;
    private final BigtableResultScannerFactory<ReadRowsRequest, Row> streamingScannerFactory = new BigtableResultScannerFactory<ReadRowsRequest, Row>(){

        @Override
        public ResultScanner<Row> createScanner(ReadRowsRequest request) {
            return BigtableDataGrpcClient.this.streamRows(request);
        }
    };
    private final BigtableAsyncUtilities asyncUtilities;
    private CallOptionsFactory callOptionsFactory = new CallOptionsFactory.Default();
    private final BigtableAsyncRpc<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysAsync;
    private final BigtableAsyncRpc<ReadRowsRequest, ReadRowsResponse> readRowsAsync;
    private final BigtableAsyncRpc<MutateRowRequest, MutateRowResponse> mutateRowRpc;
    private final BigtableAsyncRpc<MutateRowsRequest, MutateRowsResponse> mutateRowsRpc;
    private final BigtableAsyncRpc<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRpc;
    private final BigtableAsyncRpc<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readWriteModifyRpc;

    private static final boolean allCellsHaveTimestamps(Iterable<Mutation> mutations) {
        for (Mutation mut : mutations) {
            if (mut.getSetCell().getTimestampMicros() > 0L) continue;
            return false;
        }
        return true;
    }

    public BigtableDataGrpcClient(ChannelPool channelPool, ScheduledExecutorService retryExecutorService, BigtableOptions bigtableOptions) {
        this(channelPool, retryExecutorService, bigtableOptions, new BigtableAsyncUtilities.Default(channelPool));
    }

    @VisibleForTesting
    BigtableDataGrpcClient(ChannelPool channelPool, ScheduledExecutorService retryExecutorService, BigtableOptions bigtableOptions, BigtableAsyncUtilities asyncUtilities) {
        this.channelPool = channelPool;
        this.retryExecutorService = retryExecutorService;
        this.bigtableOptions = bigtableOptions;
        this.retryOptions = bigtableOptions.getRetryOptions();
        this.asyncUtilities = asyncUtilities;
        this.sampleRowKeysAsync = asyncUtilities.createStreamingAsyncRpc(BigtableGrpc.METHOD_SAMPLE_ROW_KEYS);
        this.readRowsAsync = asyncUtilities.createStreamingAsyncRpc(BigtableGrpc.METHOD_READ_ROWS);
        this.mutateRowRpc = asyncUtilities.createAsyncUnaryRpc(BigtableGrpc.METHOD_MUTATE_ROW, this.getMutationRetryableFunction(IS_RETRYABLE_MUTATION));
        this.mutateRowsRpc = asyncUtilities.createAsyncUnaryRpc(BigtableGrpc.METHOD_MUTATE_ROWS, this.getMutationRetryableFunction(ARE_RETRYABLE_MUTATIONS));
        this.checkAndMutateRpc = asyncUtilities.createAsyncUnaryRpc(BigtableGrpc.METHOD_CHECK_AND_MUTATE_ROW, this.getMutationRetryableFunction(IS_RETRYABLE_CHECK_AND_MUTATE));
        this.readWriteModifyRpc = asyncUtilities.createAsyncUnaryRpc(BigtableGrpc.METHOD_READ_MODIFY_WRITE_ROW, Predicates.alwaysFalse());
    }

    @Override
    public void setCallOptionsFactory(CallOptionsFactory callOptionsFactory) {
        this.callOptionsFactory = callOptionsFactory;
    }

    private <T> Predicate<T> getMutationRetryableFunction(Predicate<T> isRetryableMutation) {
        if (this.retryOptions.allowRetriesWithoutTimestamp()) {
            return Predicates.alwaysTrue();
        }
        return isRetryableMutation;
    }

    @Override
    public MutateRowResponse mutateRow(MutateRowRequest request) throws ServiceException {
        return this.getBlockingUnaryResult(request, this.mutateRowRpc, request.getTableName());
    }

    @Override
    public ListenableFuture<MutateRowResponse> mutateRowAsync(MutateRowRequest request) {
        return this.getUnaryFuture(request, this.mutateRowRpc, request.getTableName());
    }

    @Override
    public List<MutateRowsResponse> mutateRows(MutateRowsRequest request) throws ServiceException {
        return this.getBlockingStreamingResult(request, this.mutateRowsRpc, request.getTableName());
    }

    @Override
    public ListenableFuture<List<MutateRowsResponse>> mutateRowsAsync(MutateRowsRequest request) {
        return this.getStreamingFuture(request, this.mutateRowsRpc, request.getTableName());
    }

    @Override
    public CheckAndMutateRowResponse checkAndMutateRow(CheckAndMutateRowRequest request) throws ServiceException {
        return this.getBlockingUnaryResult(request, this.checkAndMutateRpc, request.getTableName());
    }

    @Override
    public ListenableFuture<CheckAndMutateRowResponse> checkAndMutateRowAsync(CheckAndMutateRowRequest request) {
        return this.getUnaryFuture(request, this.checkAndMutateRpc, request.getTableName());
    }

    @Override
    public ReadModifyWriteRowResponse readModifyWriteRow(ReadModifyWriteRowRequest request) {
        return this.getBlockingUnaryResult(request, this.readWriteModifyRpc, request.getTableName());
    }

    @Override
    public ListenableFuture<ReadModifyWriteRowResponse> readModifyWriteRowAsync(ReadModifyWriteRowRequest request) {
        return this.getUnaryFuture(request, this.readWriteModifyRpc, request.getTableName());
    }

    @Override
    public ImmutableList<SampleRowKeysResponse> sampleRowKeys(SampleRowKeysRequest request) {
        return ImmutableList.copyOf(this.getBlockingStreamingResult(request, this.sampleRowKeysAsync, request.getTableName()));
    }

    @Override
    public ListenableFuture<List<SampleRowKeysResponse>> sampleRowKeysAsync(SampleRowKeysRequest request) {
        return this.getStreamingFuture(request, this.sampleRowKeysAsync, request.getTableName());
    }

    @Override
    public ListenableFuture<List<Row>> readRowsAsync(ReadRowsRequest request) {
        return Futures.transform(this.getStreamingFuture(request, this.readRowsAsync, request.getTableName()), ROW_TRANSFORMER);
    }

    protected <ReqT, RespT> ListenableFuture<List<RespT>> getStreamingFuture(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String tableName) {
        return BigtableDataGrpcClient.getCompletionFuture(this.createStreamingListener(request, rpc, tableName));
    }

    private <ReqT, RespT> List<RespT> getBlockingStreamingResult(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String tableName) {
        return (List)BigtableDataGrpcClient.getBlockingResult(this.createStreamingListener(request, rpc, tableName));
    }

    private <ReqT, RespT> ListenableFuture<RespT> getUnaryFuture(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String tableName) {
        this.expandPoolIfNecessary(this.bigtableOptions.getChannelCount());
        return BigtableDataGrpcClient.getCompletionFuture(this.createUnaryListener(request, rpc, tableName));
    }

    private <ReqT, RespT> RespT getBlockingUnaryResult(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String tableName) {
        return (RespT)BigtableDataGrpcClient.getBlockingResult(this.createUnaryListener(request, rpc, tableName));
    }

    private <ReqT, RespT> RetryingUnaryRpcListener<ReqT, RespT> createUnaryListener(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String tableName) {
        return new RetryingUnaryRpcListener<ReqT, RespT>(this.retryOptions, request, rpc, this.getCallOptions(request, rpc), this.retryExecutorService, this.createMetadata(tableName));
    }

    private <ReqT, RespT> RetryingCollectingClientCallListener<ReqT, RespT> createStreamingListener(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String tableName) {
        return new RetryingCollectingClientCallListener<ReqT, RespT>(this.retryOptions, request, rpc, this.getCallOptions(request, rpc), this.retryExecutorService, this.createMetadata(tableName));
    }

    private <ReqT> CallOptions getCallOptions(ReqT request, BigtableAsyncRpc<ReqT, ?> rpc) {
        return this.callOptionsFactory.create(rpc.getMethodDescriptor(), request);
    }

    private static <ReqT, RespT, OutputT> ListenableFuture<OutputT> getCompletionFuture(AbstractRetryingRpcListener<ReqT, RespT, OutputT> listener) {
        listener.run();
        return listener.getCompletionFuture();
    }

    private static <ReqT, RespT, OutputT> OutputT getBlockingResult(AbstractRetryingRpcListener<ReqT, RespT, OutputT> listener) {
        try {
            listener.run();
            return (OutputT)listener.getCompletionFuture().get();
        }
        catch (InterruptedException e) {
            listener.cancel();
            Thread.currentThread().interrupt();
            throw Status.CANCELLED.withCause(e).asRuntimeException();
        }
        catch (ExecutionException e) {
            listener.cancel();
            throw Status.fromThrowable(e).asRuntimeException();
        }
    }

    private Metadata createMetadata(String tableName) {
        Metadata metadata = new Metadata();
        if (tableName != null) {
            metadata.put(GRPC_RESOURCE_PREFIX_KEY, tableName);
        }
        return metadata;
    }

    @Override
    public ResultScanner<Row> readRows(ReadRowsRequest request) {
        if (this.retryOptions.enableRetries()) {
            return new ResumingStreamingResultScanner(this.retryOptions, request, this.streamingScannerFactory);
        }
        return this.streamRows(request);
    }

    private ResultScanner<Row> streamRows(ReadRowsRequest request) {
        this.expandPoolIfNecessary(this.bigtableOptions.getChannelCount());
        ClientCall<ReadRowsRequest, ReadRowsResponse> readRowsCall = this.channelPool.newCall(BigtableGrpc.METHOD_READ_ROWS, CallOptions.DEFAULT);
        ResponseQueueReader responseQueueReader = new ResponseQueueReader(this.retryOptions.getReadPartialRowTimeoutMillis(), this.retryOptions.getStreamingBufferSize());
        RowMerger rowMerger = new RowMerger(responseQueueReader);
        StreamObserverAdapter<ReadRowsResponse> listener = new StreamObserverAdapter<ReadRowsResponse>(readRowsCall, rowMerger);
        this.asyncUtilities.asyncServerStreamingCall(readRowsCall, request, listener, this.createMetadata(request.getTableName()));
        CancellationToken cancellationToken = this.createCancellationToken(readRowsCall);
        return new StreamingBigtableResultScanner(responseQueueReader, cancellationToken);
    }

    private CancellationToken createCancellationToken(final ClientCall<ReadRowsRequest, ReadRowsResponse> readRowsCall) {
        CancellationToken cancellationToken = new CancellationToken();
        cancellationToken.addListener(new Runnable(){

            @Override
            public void run() {
                readRowsCall.cancel("User requested cancelation.", null);
            }
        }, MoreExecutors.directExecutor());
        return cancellationToken;
    }

    private void expandPoolIfNecessary(int channelCount) {
        try {
            this.channelPool.ensureChannelCount(channelCount);
        }
        catch (IOException e) {
            LOG.info("Could not expand the channel pool.", e, new Object[0]);
        }
    }
}

