/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.grpc;

import com.google.bigtable.repackaged.com.google.api.client.util.Strings;
import com.google.bigtable.repackaged.com.google.cloud.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.config.CredentialFactory;
import com.google.bigtable.repackaged.com.google.cloud.config.CredentialOptions;
import com.google.bigtable.repackaged.com.google.cloud.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableDataClient;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableDataGrpcClient;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableInstanceClient;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableInstanceGrpcClient;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableSessionSharedThreadPools;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableTableAdminClient;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableTableAdminGrpcClient;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableTableName;
import com.google.bigtable.repackaged.com.google.cloud.grpc.CallOptionsFactory;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.AsyncExecutor;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.BulkMutation;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.BulkRead;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.ResourceLimiter;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.RpcThrottler;
import com.google.bigtable.repackaged.com.google.cloud.grpc.io.ChannelPool;
import com.google.bigtable.repackaged.com.google.cloud.grpc.io.CredentialInterceptorCache;
import com.google.bigtable.repackaged.com.google.cloud.grpc.io.HeaderInterceptor;
import com.google.bigtable.repackaged.com.google.cloud.util.ThreadPoolUtil;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import com.google.bigtable.repackaged.io.grpc.netty.GrpcSslContexts;
import com.google.bigtable.repackaged.io.grpc.netty.NegotiationType;
import com.google.bigtable.repackaged.io.grpc.netty.NettyChannelBuilder;
import com.google.bigtable.repackaged.io.netty.channel.EventLoopGroup;
import com.google.bigtable.repackaged.io.netty.handler.ssl.OpenSsl;
import com.google.bigtable.repackaged.io.netty.handler.ssl.SslContext;
import com.google.bigtable.repackaged.io.netty.handler.ssl.SslContextBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

public class BigtableSession
implements Closeable {
    private static final Logger LOG = new Logger(BigtableSession.class);
    private static SslContextBuilder sslBuilder;
    private static ResourceLimiter resourceLimiter;
    private static final int MAX_MESSAGE_SIZE = 0x10000000;
    private static final int FLOW_CONTROL_WINDOW = 0x100000;
    @VisibleForTesting
    static final String PROJECT_ID_EMPTY_OR_NULL = "ProjectId must not be empty or null.";
    @VisibleForTesting
    static final String INSTANCE_ID_EMPTY_OR_NULL = "InstanceId must not be empty or null.";
    @VisibleForTesting
    static final String USER_AGENT_EMPTY_OR_NULL = "UserAgent must not be empty or null";
    private final BigtableDataClient dataClient;
    private BigtableTableAdminClient tableAdminClient;
    private BigtableInstanceGrpcClient instanceAdminClient;
    private final BigtableOptions options;
    private final List<ManagedChannel> managedChannels = Collections.synchronizedList(new ArrayList());
    private final ImmutableList<HeaderInterceptor> headerInterceptors;

    private static synchronized SslContext createSslContext() throws SSLException {
        if (sslBuilder == null) {
            sslBuilder = GrpcSslContexts.forClient().ciphers(null);
            if (OpenSsl.isAvailable()) {
                LOG.info("SslContext: gRPC is using the OpenSSL provider (tcnactive jar - Open Ssl version: %s)", OpenSsl.versionString());
            } else if (BigtableSession.isJettyAlpnConfigured()) {
                LOG.info("SslContext: gRPC is using the JDK provider (alpn-boot jar)", new Object[0]);
            } else {
                LOG.info("SslContext: gRPC cannot be configured.  Neither OpenSsl nor Alpn are available.", new Object[0]);
            }
        }
        return sslBuilder.build();
    }

    public static boolean isAlpnProviderEnabled() {
        boolean openSslAvailable = OpenSsl.isAvailable();
        boolean jettyAlpnConfigured = BigtableSession.isJettyAlpnConfigured();
        LOG.debug("OpenSSL available: %s", openSslAvailable);
        LOG.debug("Jetty ALPN available: %s", jettyAlpnConfigured);
        return openSslAvailable || jettyAlpnConfigured;
    }

    private static boolean isJettyAlpnConfigured() {
        String alpnClassName = "org.eclipse.jetty.alpn.ALPN";
        try {
            Class.forName("org.eclipse.jetty.alpn.ALPN", true, null);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
        catch (Exception e) {
            LOG.warn("Could not resolve alpn class: %s", e, "org.eclipse.jetty.alpn.ALPN");
            return false;
        }
    }

    private static void performWarmup() {
        ExecutorService connectionStartupExecutor = Executors.newCachedThreadPool(ThreadPoolUtil.createThreadFactory("BigtableSession-startup"));
        connectionStartupExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (BigtableSession.isAlpnProviderEnabled()) {
                    try {
                        BigtableSession.createSslContext();
                    }
                    catch (SSLException e) {
                        LOG.warn("Could not asynchronously create the ssl context", e, new Object[0]);
                    }
                }
            }
        });
        connectionStartupExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CredentialFactory.getHttpTransport();
                }
                catch (IOException | GeneralSecurityException e) {
                    LOG.warn("Could not asynchronously initialze httpTransport", e, new Object[0]);
                }
            }
        });
        connectionStartupExecutor.execute(new Runnable(){

            @Override
            public void run() {
                BigtableSessionSharedThreadPools.getInstance();
            }
        });
        for (final String host : Arrays.asList("bigtable.googleapis.com", "bigtableadmin.googleapis.com")) {
            connectionStartupExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        InetAddress.getByName(host);
                    }
                    catch (UnknownHostException e) {
                        LOG.warn("Could not asynchronously initialze host: " + host, e, new Object[0]);
                    }
                }
            });
        }
        connectionStartupExecutor.shutdown();
    }

    private static synchronized void initializeResourceLimiter(BigtableOptions options) {
        if (resourceLimiter == null) {
            int maxInflightRpcs = options.getBulkOptions().getMaxInflightRpcs();
            long maxMemory = options.getBulkOptions().getMaxMemory();
            resourceLimiter = new ResourceLimiter(maxMemory, maxInflightRpcs);
        }
    }

    public BigtableSession(BigtableOptions options) throws IOException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(options.getProjectId()), PROJECT_ID_EMPTY_OR_NULL);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(options.getInstanceId()), INSTANCE_ID_EMPTY_OR_NULL);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(options.getUserAgent()), USER_AGENT_EMPTY_OR_NULL);
        LOG.info("Opening connection for projectId %s, instanceId %s, on data host %s, table admin host %s.", options.getProjectId(), options.getInstanceId(), options.getDataHost(), options.getTableAdminHost());
        LOG.info("Bigtable options: %s.", options);
        if (!BigtableSession.isAlpnProviderEnabled()) {
            LOG.error("Neither Jetty ALPN nor OpenSSL are available. OpenSSL unavailability cause:\n%s", OpenSsl.unavailabilityCause().toString());
            throw new IllegalStateException("Neither Jetty ALPN nor OpenSSL via netty-tcnative were properly configured.");
        }
        this.options = options;
        ImmutableList.Builder headerInterceptorBuilder = new ImmutableList.Builder();
        CredentialInterceptorCache credentialsCache = CredentialInterceptorCache.getInstance();
        RetryOptions retryOptions = options.getRetryOptions();
        CredentialOptions credentialOptions = options.getCredentialOptions();
        try {
            HeaderInterceptor headerInterceptor = credentialsCache.getCredentialsInterceptor(credentialOptions, retryOptions);
            if (headerInterceptor != null) {
                headerInterceptorBuilder.add(headerInterceptor);
            }
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Could not initialize credentials.", e);
        }
        this.headerInterceptors = headerInterceptorBuilder.build();
        ChannelPool dataChannel = this.createChannelPool(options.getDataHost());
        BigtableSessionSharedThreadPools sharedPools = BigtableSessionSharedThreadPools.getInstance();
        this.dataClient = new BigtableDataGrpcClient(dataChannel, sharedPools.getRetryExecutor(), options);
        this.dataClient.setCallOptionsFactory(new CallOptionsFactory.ConfiguredCallOptionsFactory(options.getCallOptionsConfig()));
        BigtableSession.initializeResourceLimiter(options);
    }

    @Deprecated
    public BigtableSession(BigtableOptions options, ExecutorService batchPool) throws IOException {
        this(options);
    }

    @Deprecated
    public BigtableSession(BigtableOptions options, @Nullable ExecutorService batchPool, @Nullable EventLoopGroup elg, @Nullable ScheduledExecutorService scheduledRetries) throws IOException {
        this(options);
        if (elg != null) {
            elg.shutdown();
        }
        if (scheduledRetries != null) {
            scheduledRetries.shutdown();
        }
    }

    public BigtableDataClient getDataClient() {
        return this.dataClient;
    }

    public AsyncExecutor createAsyncExecutor() {
        return new AsyncExecutor(this.dataClient, new RpcThrottler(resourceLimiter));
    }

    public BulkMutation createBulkMutation(BigtableTableName tableName, AsyncExecutor asyncExecutor) {
        return new BulkMutation(tableName, asyncExecutor, this.options.getRetryOptions(), BigtableSessionSharedThreadPools.getInstance().getRetryExecutor(), this.options.getBulkOptions().getBulkMaxRowKeyCount(), this.options.getBulkOptions().getBulkMaxRequestSize());
    }

    public BulkRead createBulkRead(BigtableTableName tableName) {
        return new BulkRead(this.dataClient, tableName);
    }

    public synchronized BigtableTableAdminClient getTableAdminClient() throws IOException {
        if (this.tableAdminClient == null) {
            ChannelPool channel = this.createChannelPool(this.options.getTableAdminHost());
            this.tableAdminClient = new BigtableTableAdminGrpcClient(channel);
        }
        return this.tableAdminClient;
    }

    public synchronized BigtableInstanceClient getInstanceAdminClient() throws IOException {
        if (this.instanceAdminClient == null) {
            ChannelPool channel = this.createChannelPool(this.options.getInstanceAdminHost());
            this.instanceAdminClient = new BigtableInstanceGrpcClient(channel);
        }
        return this.instanceAdminClient;
    }

    protected ChannelPool createChannelPool(final String hostString) throws IOException {
        ChannelPool.ChannelFactory channelFactory = new ChannelPool.ChannelFactory(){

            @Override
            public ManagedChannel create() throws IOException {
                return BigtableSession.createNettyChannel(hostString, BigtableSession.this.options);
            }
        };
        ChannelPool channelPool = new ChannelPool(this.headerInterceptors, channelFactory);
        this.managedChannels.add(channelPool);
        return channelPool;
    }

    public static ManagedChannel createNettyChannel(String host, BigtableOptions options) throws IOException {
        NegotiationType negotiationType = options.usePlaintextNegotiation() ? NegotiationType.PLAINTEXT : NegotiationType.TLS;
        BigtableSessionSharedThreadPools sharedPools = BigtableSessionSharedThreadPools.getInstance();
        return ((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress(host, options.getPort()).maxMessageSize(0x10000000).sslContext(BigtableSession.createSslContext()).eventLoopGroup(sharedPools.getElg()).executor(sharedPools.getBatchThreadPool())).negotiationType(negotiationType).userAgent(options.getUserAgent())).flowControlWindow(0x100000).build();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.managedChannels.isEmpty()) {
            return;
        }
        long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
        long endTimeNanos = System.nanoTime() + timeoutNanos;
        for (ManagedChannel channel : this.managedChannels) {
            channel.shutdown();
        }
        for (ManagedChannel channel : this.managedChannels) {
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            if (awaitTimeNanos <= 0L) break;
            try {
                channel.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted while closing the channelPools");
            }
        }
        for (ManagedChannel channel : this.managedChannels) {
            if (channel.isTerminated()) continue;
            LOG.info("Could not close the channel after 10 seconds.", new Object[0]);
            break;
        }
        this.managedChannels.clear();
    }

    public BigtableOptions getOptions() {
        return this.options;
    }

    static {
        BigtableSession.performWarmup();
    }
}

