/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.grpc;

import com.google.bigtable.repackaged.com.google.cloud.util.ThreadPoolUtil;
import com.google.bigtable.repackaged.io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public class BigtableSessionSharedThreadPools {
    public static final String BATCH_POOL_THREAD_NAME = "bigtable-batch-pool";
    public static final String RETRY_THREADPOOL_NAME = "bigtable-rpc-retry";
    public static final String GRPC_EVENTLOOP_GROUP_NAME = "bigtable-grpc-elg";
    public static final int RETRY_THREAD_COUNT = 4;
    private static BigtableSessionSharedThreadPools INSTANCE = new BigtableSessionSharedThreadPools();
    protected ExecutorService batchThreadPool;
    protected NioEventLoopGroup elg;
    protected ScheduledExecutorService retryExecutor;

    public static BigtableSessionSharedThreadPools getInstance() {
        return INSTANCE;
    }

    protected BigtableSessionSharedThreadPools() {
        this.init();
    }

    protected void init() {
        this.batchThreadPool = Executors.newCachedThreadPool(this.createThreadFactory(BATCH_POOL_THREAD_NAME));
        this.elg = new NioEventLoopGroup(0, this.createThreadFactory(GRPC_EVENTLOOP_GROUP_NAME));
        this.retryExecutor = Executors.newScheduledThreadPool(4, this.createThreadFactory(RETRY_THREADPOOL_NAME));
    }

    protected ThreadFactory createThreadFactory(String name) {
        return ThreadPoolUtil.createThreadFactory(name);
    }

    public ExecutorService getBatchThreadPool() {
        return this.batchThreadPool;
    }

    public NioEventLoopGroup getElg() {
        return this.elg;
    }

    public ScheduledExecutorService getRetryExecutor() {
        return this.retryExecutor;
    }
}

