/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.grpc;

import com.google.bigtable.repackaged.com.google.cloud.config.CallOptionsConfig;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Deadline;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import java.util.concurrent.TimeUnit;

public interface CallOptionsFactory {
    public <RequestT> CallOptions create(MethodDescriptor<RequestT, ?> var1, RequestT var2);

    public static class ConfiguredCallOptionsFactory
    implements CallOptionsFactory {
        private final CallOptionsConfig config;

        public ConfiguredCallOptionsFactory(CallOptionsConfig config) {
            this.config = config;
        }

        @Override
        public <RequestT> CallOptions create(MethodDescriptor<RequestT, ?> descriptor, RequestT request) {
            if (this.config.isUseTimeout()) {
                return CallOptions.DEFAULT.withDeadline(Deadline.after(this.config.getTimeoutMs(), TimeUnit.MILLISECONDS));
            }
            return CallOptions.DEFAULT;
        }
    }

    public static class Default
    implements CallOptionsFactory {
        @Override
        public <RequestT> CallOptions create(MethodDescriptor<RequestT, ?> descriptor, RequestT request) {
            return CallOptions.DEFAULT;
        }
    }
}

