/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.grpc.async;

import com.google.bigtable.repackaged.com.google.api.client.util.BackOff;
import com.google.bigtable.repackaged.com.google.api.client.util.Sleeper;
import com.google.bigtable.repackaged.com.google.cloud.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.BigtableAsyncRpc;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.BigtableRetriesExhaustedException;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.AbstractFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class AbstractRetryingRpcListener<RequestT, ResponseT, ResultT>
extends ClientCall.Listener<ResponseT>
implements Runnable {
    protected static final Logger LOG = new Logger(AbstractRetryingRpcListener.class);
    @VisibleForTesting
    BackOff currentBackoff;
    @VisibleForTesting
    Sleeper sleeper = Sleeper.DEFAULT;
    private final BigtableAsyncRpc<RequestT, ResponseT> rpc;
    private final RetryOptions retryOptions;
    private final RequestT request;
    private final CallOptions callOptions;
    private final ScheduledExecutorService retryExecutorService;
    private int failedCount;
    private final Metadata originalMetadata;
    protected final GrpcFuture<ResultT> completionFuture = new GrpcFuture();
    protected ClientCall<RequestT, ResponseT> call;

    public AbstractRetryingRpcListener(RetryOptions retryOptions, RequestT request, BigtableAsyncRpc<RequestT, ResponseT> retryableRpc, CallOptions callOptions, ScheduledExecutorService retryExecutorService, Metadata originalMetadata) {
        this.retryOptions = retryOptions;
        this.request = request;
        this.rpc = retryableRpc;
        this.callOptions = callOptions;
        this.retryExecutorService = retryExecutorService;
        this.originalMetadata = originalMetadata;
    }

    @Override
    public void onClose(Status status, Metadata trailers) {
        if (status.isOk()) {
            this.onOK();
        } else {
            Status.Code code = status.getCode();
            if (this.retryOptions.enableRetries() && this.retryOptions.isRetryable(code) && this.rpc.isRetryable(this.request)) {
                this.backOffAndRetry(status);
            } else {
                this.completionFuture.setException(status.asRuntimeException());
            }
        }
    }

    protected abstract void onOK();

    private void backOffAndRetry(Status status) {
        long nextBackOff = this.getNextBackoff();
        ++this.failedCount;
        if (nextBackOff == -1L) {
            String message = String.format("Exhausted retries after %d failures.", this.failedCount);
            StatusRuntimeException cause = status.asRuntimeException();
            this.completionFuture.setException(new BigtableRetriesExhaustedException(message, cause));
            return;
        }
        LOG.info("Retrying failed call. Failure #%d, got: %s", status.getCause(), this.failedCount, status);
        if (this.call != null) {
            this.call.cancel(String.format("Request being retried. Previous call failed with status %s.", status.getCode().name()), null);
        }
        this.call = null;
        this.retryExecutorService.schedule(this, nextBackOff, TimeUnit.MILLISECONDS);
    }

    private long getNextBackoff() {
        if (this.currentBackoff == null) {
            this.currentBackoff = this.retryOptions.createBackoff();
        }
        try {
            return this.currentBackoff.nextBackOffMillis();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public ListenableFuture<ResultT> getCompletionFuture() {
        return this.completionFuture;
    }

    @Override
    public void run() {
        Metadata metadata = new Metadata();
        metadata.merge(this.originalMetadata);
        this.call = this.rpc.call(this.request, this, this.callOptions, metadata);
    }

    public void cancel() {
        if (this.call != null) {
            this.call.cancel("User requested cancelation.", null);
        }
    }

    protected class GrpcFuture<RespT>
    extends AbstractFuture<RespT> {
        protected GrpcFuture() {
        }

        @Override
        protected void interruptTask() {
            if (AbstractRetryingRpcListener.this.call != null) {
                AbstractRetryingRpcListener.this.call.cancel("Request interrupted.", null);
            }
        }

        @Override
        protected boolean set(@Nullable RespT resp) {
            return super.set(resp);
        }

        @Override
        protected boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }
    }
}

