/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.grpc.async;

import com.google.bigtable.repackaged.com.google.cloud.grpc.async.BigtableAsyncRpc;
import com.google.bigtable.repackaged.com.google.common.base.Predicate;
import com.google.bigtable.repackaged.com.google.common.base.Throwables;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;

public interface BigtableAsyncUtilities {
    public <RequestT, ResponseT> BigtableAsyncRpc<RequestT, ResponseT> createStreamingAsyncRpc(MethodDescriptor<RequestT, ResponseT> var1);

    public <RequestT, ResponseT> BigtableAsyncRpc<RequestT, ResponseT> createAsyncUnaryRpc(MethodDescriptor<RequestT, ResponseT> var1, Predicate<RequestT> var2);

    public <RequestT, ResponseT> void asyncServerStreamingCall(ClientCall<RequestT, ResponseT> var1, RequestT var2, ClientCall.Listener<ResponseT> var3, Metadata var4);

    public static class Default
    implements BigtableAsyncUtilities {
        private final Channel channel;

        public Default(Channel channel) {
            this.channel = channel;
        }

        @Override
        public <RequestT, ResponseT> BigtableAsyncRpc<RequestT, ResponseT> createAsyncUnaryRpc(final MethodDescriptor<RequestT, ResponseT> method, final Predicate<RequestT> isRetryable) {
            return new BigtableAsyncRpc<RequestT, ResponseT>(){

                @Override
                public ClientCall<RequestT, ResponseT> call(RequestT request, ClientCall.Listener<ResponseT> listener, CallOptions callOptions, Metadata metadata) {
                    return Default.this.createCall(Default.this.channel, callOptions, method, request, listener, 1, metadata);
                }

                @Override
                public boolean isRetryable(RequestT request) {
                    return isRetryable.apply(request);
                }

                @Override
                public MethodDescriptor<RequestT, ResponseT> getMethodDescriptor() {
                    return method;
                }
            };
        }

        @Override
        public <RequestT, ResponseT> BigtableAsyncRpc<RequestT, ResponseT> createStreamingAsyncRpc(final MethodDescriptor<RequestT, ResponseT> method) {
            return new BigtableAsyncRpc<RequestT, ResponseT>(){

                @Override
                public boolean isRetryable(RequestT request) {
                    return true;
                }

                @Override
                public ClientCall<RequestT, ResponseT> call(RequestT request, ClientCall.Listener<ResponseT> listener, CallOptions callOptions, Metadata metadata) {
                    return Default.this.createCall(Default.this.channel, callOptions, method, request, listener, 1, metadata);
                }

                @Override
                public MethodDescriptor<RequestT, ResponseT> getMethodDescriptor() {
                    return method;
                }
            };
        }

        @Override
        public <RequestT, ResponseT> void asyncServerStreamingCall(ClientCall<RequestT, ResponseT> call, RequestT request, ClientCall.Listener<ResponseT> listener, Metadata metadata) {
            Default.start(call, request, listener, 1, metadata);
        }

        private <RequestT, ResponseT> ClientCall<RequestT, ResponseT> createCall(Channel channel, CallOptions callOptions, MethodDescriptor<RequestT, ResponseT> method, RequestT request, ClientCall.Listener<ResponseT> listener, int count, Metadata metadata) {
            ClientCall<RequestT, ResponseT> call = channel.newCall(method, callOptions);
            Default.start(call, request, listener, count, metadata);
            return call;
        }

        private static <RequestT, ResponseT> void start(ClientCall<RequestT, ResponseT> call, RequestT request, ClientCall.Listener<ResponseT> listener, int requestCount, Metadata metadata) {
            call.start(listener, metadata);
            call.request(requestCount);
            try {
                call.sendMessage(request);
            }
            catch (Throwable t) {
                call.cancel("Exception in sendMessage.", t);
                throw Throwables.propagate(t);
            }
            try {
                call.halfClose();
            }
            catch (Throwable t) {
                call.cancel("Exception in halfClose.", t);
                throw Throwables.propagate(t);
            }
        }
    }
}

