/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.grpc.async;

import com.google.bigtable.repackaged.com.google.api.client.util.BackOff;
import com.google.bigtable.repackaged.com.google.cloud.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableTableName;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.AsyncExecutor;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.BigtableRetriesExhaustedException;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.FutureCallback;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.Any;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class BulkMutation {
    private static final StatusRuntimeException MISSING_ENTRY_EXCEPTION = Status.UNKNOWN.withDescription("Mutation does not have a status").asRuntimeException();
    protected static final Logger LOG = new Logger(BulkMutation.class);
    @VisibleForTesting
    Batch currentBatch = null;
    private final String tableName;
    private final AsyncExecutor asyncExecutor;
    private final RetryOptions retryOptions;
    private final ScheduledExecutorService retryExecutorService;
    private final int maxRowKeyCount;
    private final long maxRequestSize;

    private static StatusRuntimeException toException(com.google.bigtable.repackaged.com.google.com.google.rpc.Status status) {
        Status grpcStatus = Status.fromCodeValue(status.getCode()).withDescription(status.getMessage());
        for (Any detail : status.getDetailsList()) {
            grpcStatus = grpcStatus.augmentDescription(detail.toString());
        }
        return grpcStatus.asRuntimeException();
    }

    @VisibleForTesting
    static MutateRowsRequest.Entry convert(MutateRowRequest request) {
        return MutateRowsRequest.Entry.newBuilder().setRowKey(request.getRowKey()).addAllMutations(request.getMutationsList()).build();
    }

    public BulkMutation(BigtableTableName tableName, AsyncExecutor asyncExecutor, RetryOptions retryOptions, ScheduledExecutorService retryExecutorService, int maxRowKeyCount, long maxRequestSize) {
        this.tableName = tableName.toString();
        this.asyncExecutor = asyncExecutor;
        this.retryOptions = retryOptions;
        this.retryExecutorService = retryExecutorService;
        this.maxRowKeyCount = maxRowKeyCount;
        this.maxRequestSize = maxRequestSize;
    }

    public synchronized ListenableFuture<MutateRowResponse> add(MutateRowRequest request) {
        if (this.currentBatch == null) {
            this.currentBatch = new Batch(this.tableName, this.asyncExecutor, this.retryOptions, this.retryExecutorService, this.maxRowKeyCount, this.maxRequestSize);
        }
        ListenableFuture<MutateRowResponse> future = this.currentBatch.add(request);
        if (this.currentBatch.isFull()) {
            this.currentBatch.run();
            this.currentBatch = null;
        }
        return future;
    }

    public synchronized void flush() {
        if (this.currentBatch != null) {
            this.currentBatch.run();
            this.currentBatch = null;
        }
    }

    public synchronized boolean isFlushed() {
        return this.currentBatch == null;
    }

    @VisibleForTesting
    static class Batch
    implements Runnable {
        private final AsyncExecutor asyncExecutor;
        private final RetryOptions retryOptions;
        private final ScheduledExecutorService retryExecutorService;
        private final int maxRowKeyCount;
        private final long maxRequestSize;
        private RequestManager currentRequestManager;
        private Long retryId;
        private BackOff currentBackoff;
        private int failedCount;

        Batch(String tableName, AsyncExecutor asyncExecutor, RetryOptions retryOptions, ScheduledExecutorService retryExecutorService, int maxRowKeyCount, long maxRequestSize) {
            this.currentRequestManager = new RequestManager(tableName);
            this.asyncExecutor = asyncExecutor;
            this.retryOptions = retryOptions;
            this.retryExecutorService = retryExecutorService;
            this.maxRowKeyCount = maxRowKeyCount;
            this.maxRequestSize = maxRequestSize;
        }

        @VisibleForTesting
        ListenableFuture<MutateRowResponse> add(MutateRowRequest request) {
            SettableFuture<MutateRowResponse> future = SettableFuture.create();
            this.currentRequestManager.add(future, BulkMutation.convert(request));
            return future;
        }

        boolean isFull() {
            return this.getRequestCount() >= this.maxRowKeyCount || this.currentRequestManager.approximateByteSize >= this.maxRequestSize;
        }

        void addCallback(ListenableFuture<List<MutateRowsResponse>> bulkFuture) {
            Futures.addCallback(bulkFuture, new FutureCallback<List<MutateRowsResponse>>(){

                @Override
                public void onSuccess(List<MutateRowsResponse> result) {
                    Batch.this.handleResult(result);
                }

                @Override
                public void onFailure(Throwable t) {
                    Batch.this.performFullRetry(new AtomicReference(), t);
                }
            });
        }

        synchronized void handleResult(List<MutateRowsResponse> results) {
            if (this.currentRequestManager == null) {
                LOG.warn("Got duplicate responses for bulk mutation.", new Object[0]);
                return;
            }
            if (results == null || results.isEmpty()) {
                this.performFullRetry(new IllegalStateException("No MutateRowResponses were found."));
                return;
            }
            ArrayList<MutateRowsResponse.Entry> entries = new ArrayList<MutateRowsResponse.Entry>();
            for (MutateRowsResponse response : results) {
                entries.addAll(response.getEntriesList());
            }
            if (entries.isEmpty()) {
                this.performFullRetry(new IllegalStateException("No MutateRowsResponses entries were found."));
                return;
            }
            AtomicReference<Long> backoffTime = new AtomicReference<Long>();
            try {
                String tableName = this.currentRequestManager.request.getTableName();
                RequestManager retryRequestManager = new RequestManager(tableName);
                this.handleResponses(backoffTime, entries, retryRequestManager);
                this.handleExtraFutures(backoffTime, retryRequestManager, entries);
                this.completeOrRetry(backoffTime, retryRequestManager);
            }
            catch (RuntimeException e) {
                LOG.error("Unexpected Exception occurred. Treating this issue as a temporary issue and retrying.", e, new Object[0]);
                this.performFullRetry(backoffTime, e);
            }
        }

        private void performFullRetry(Throwable t) {
            this.performFullRetry(new AtomicReference<Long>(), t);
        }

        private void performFullRetry(AtomicReference<Long> backoff, Throwable t) {
            Long backoffMs = this.getCurrentBackoff(backoff);
            if (backoffMs == -1L) {
                this.setFailure(new BigtableRetriesExhaustedException("Exhausted retries.", t));
            } else {
                LOG.info("Retrying failed call. Failure #%d, got: %s", t, this.failedCount++, Status.fromThrowable(t));
                this.retryExecutorService.schedule(this, (long)backoffMs, TimeUnit.MILLISECONDS);
            }
        }

        private Long getCurrentBackoff(AtomicReference<Long> backOffTime) {
            if (backOffTime.get() == null) {
                try {
                    if (this.currentBackoff == null) {
                        this.currentBackoff = this.retryOptions.createBackoff();
                    }
                    backOffTime.set(this.currentBackoff.nextBackOffMillis());
                }
                catch (IOException e) {
                    LOG.warn("Could not get the next backoff.", e, new Object[0]);
                    backOffTime.set(-1L);
                }
            }
            return backOffTime.get();
        }

        private void handleResponses(AtomicReference<Long> backoffTime, Iterable<MutateRowsResponse.Entry> entries, RequestManager retryRequestManager) {
            for (MutateRowsResponse.Entry entry : entries) {
                int index = (int)entry.getIndex();
                if (index >= this.currentRequestManager.futures.size()) {
                    LOG.error("Got extra status: %s", entry);
                    break;
                }
                SettableFuture future = (SettableFuture)this.currentRequestManager.futures.get(index);
                com.google.bigtable.repackaged.com.google.com.google.rpc.Status status = entry.getStatus();
                int statusCode = status.getCode();
                if (statusCode == Status.Code.OK.value()) {
                    future.set(MutateRowResponse.getDefaultInstance());
                    continue;
                }
                if (!this.isRetryable(statusCode) || this.getCurrentBackoff(backoffTime) == -1L) {
                    future.setException(BulkMutation.toException(status));
                    continue;
                }
                retryRequestManager.add(future, this.currentRequestManager.request.getEntries(index));
            }
        }

        private void handleExtraFutures(AtomicReference<Long> backoffTime, RequestManager retryRequestManager, List<MutateRowsResponse.Entry> entries) {
            HashSet<Integer> indexes = new HashSet<Integer>();
            indexes.addAll(this.getIndexes(entries));
            long missingEntriesCount = 0L;
            this.getCurrentBackoff(backoffTime);
            for (int i = 0; i < this.currentRequestManager.futures.size(); ++i) {
                if (indexes.remove(i)) continue;
                ++missingEntriesCount;
                if (backoffTime.get() == -1L) {
                    ((SettableFuture)this.currentRequestManager.futures.get(i)).setException(MISSING_ENTRY_EXCEPTION);
                    continue;
                }
                retryRequestManager.add((SettableFuture)this.currentRequestManager.futures.get(i), this.currentRequestManager.request.getEntries(i));
            }
            if (missingEntriesCount > 0L) {
                String handling = backoffTime.get() == -1L ? "Setting exceptions on the futures" : "Retrying";
                LOG.error("Missing %d responses for bulkWrite. %s.", missingEntriesCount, handling);
            }
        }

        private List<Integer> getIndexes(List<MutateRowsResponse.Entry> entries) {
            ArrayList<Integer> indexes = new ArrayList<Integer>(entries.size());
            for (MutateRowsResponse.Entry entry : entries) {
                indexes.add((int)entry.getIndex());
            }
            return indexes;
        }

        private void completeOrRetry(AtomicReference<Long> backoffTime, RequestManager retryRequestManager) {
            if (retryRequestManager == null || retryRequestManager.futures.isEmpty()) {
                this.currentRequestManager = null;
                this.setRetryComplete();
            } else {
                this.currentRequestManager = retryRequestManager;
                LOG.info("Retrying failed call. Failure #%d, got #%d failures", this.failedCount++, this.currentRequestManager.futures.size());
                this.retryExecutorService.schedule(this, (long)this.getCurrentBackoff(backoffTime), TimeUnit.MILLISECONDS);
            }
        }

        protected boolean isRetryable(int codeId) {
            Status.Code code = Status.fromCodeValue(codeId).getCode();
            return this.retryOptions.isRetryable(code);
        }

        @Override
        public synchronized void run() {
            ListenableFuture<List<MutateRowsResponse>> future = null;
            try {
                if (this.retryId == null) {
                    this.retryId = this.asyncExecutor.getRpcThrottler().registerRetry();
                }
                MutateRowsRequest request = this.currentRequestManager.build();
                future = this.asyncExecutor.mutateRowsAsync(request);
            }
            catch (InterruptedException e) {
                future = Futures.immediateFailedFuture(e);
            }
            finally {
                this.addCallback(future);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setFailure(Throwable t) {
            try {
                for (SettableFuture future : this.currentRequestManager.futures) {
                    future.setException(t);
                }
            }
            finally {
                this.setRetryComplete();
            }
        }

        private void setRetryComplete() {
            this.asyncExecutor.getRpcThrottler().onRetryCompletion(this.retryId);
        }

        @VisibleForTesting
        int getRequestCount() {
            return this.currentRequestManager == null ? 0 : this.currentRequestManager.futures.size();
        }
    }

    @VisibleForTesting
    static class RequestManager {
        private final List<SettableFuture<MutateRowResponse>> futures = new ArrayList<SettableFuture<MutateRowResponse>>();
        private final MutateRowsRequest.Builder builder;
        private MutateRowsRequest request;
        private long approximateByteSize = 0L;

        RequestManager(String tableName) {
            this.builder = MutateRowsRequest.newBuilder().setTableName(tableName);
            this.approximateByteSize = tableName.length() + 2;
        }

        void add(SettableFuture<MutateRowResponse> future, MutateRowsRequest.Entry entry) {
            this.futures.add(future);
            this.builder.addEntries(entry);
            this.approximateByteSize += (long)entry.getSerializedSize();
        }

        MutateRowsRequest build() {
            this.request = this.builder.build();
            return this.request;
        }
    }
}

