/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.grpc.async;

import com.google.bigtable.repackaged.com.google.cloud.config.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ResourceLimiter {
    private static final Logger LOG = new Logger(ResourceLimiter.class);
    private static final long REGISTER_WAIT_MILLIS = 5L;
    private final long maxHeapSize;
    private final int maxInFlightRpcs;
    private final AtomicLong operationSequenceGenerator = new AtomicLong();
    private final Map<Long, Long> pendingOperationsWithSize = new HashMap<Long, Long>();
    private final LinkedBlockingDeque<Long> completedOperationIds = new LinkedBlockingDeque();
    private long currentWriteBufferSize;

    public ResourceLimiter(long maxHeapSize, int maxInFlightRpcs) {
        this.maxHeapSize = maxHeapSize;
        this.maxInFlightRpcs = maxInFlightRpcs;
    }

    public synchronized long registerOperationWithHeapSize(long heapSize) throws InterruptedException {
        long operationId = this.operationSequenceGenerator.incrementAndGet();
        while (this.unsynchronizedIsFull()) {
            this.waitForCompletions(5L);
        }
        this.pendingOperationsWithSize.put(operationId, heapSize);
        this.currentWriteBufferSize += heapSize;
        return operationId;
    }

    public void markCanBeCompleted(long id) {
        this.completedOperationIds.offerLast(id);
    }

    public long getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public int getMaxInFlightRpcs() {
        return this.maxInFlightRpcs;
    }

    public long getHeapSize() {
        return this.currentWriteBufferSize;
    }

    public synchronized boolean isFull() {
        return this.unsynchronizedIsFull();
    }

    private boolean isFullInternal() {
        return this.currentWriteBufferSize >= this.maxHeapSize || this.pendingOperationsWithSize.size() >= this.maxInFlightRpcs;
    }

    private boolean unsynchronizedIsFull() {
        if (!this.isFullInternal()) {
            return false;
        }
        this.cleanupFinishedOperations();
        return this.isFullInternal();
    }

    public synchronized boolean hasInflightRequests() {
        this.cleanupFinishedOperations();
        return !this.pendingOperationsWithSize.isEmpty();
    }

    private void cleanupFinishedOperations() {
        ArrayList<Long> toClean = new ArrayList<Long>();
        this.completedOperationIds.drainTo(toClean);
        if (!toClean.isEmpty()) {
            this.markOperationsCompleted(toClean);
        }
    }

    private synchronized void markOperationsCompleted(List<Long> operationSequenceIds) {
        for (Long operationSequenceId : operationSequenceIds) {
            this.markOperationComplete(operationSequenceId);
        }
    }

    private void waitForCompletions(long timeoutMs) throws InterruptedException {
        Long completedOperation = this.completedOperationIds.pollFirst(timeoutMs, TimeUnit.MILLISECONDS);
        if (completedOperation != null) {
            this.markOperationComplete(completedOperation);
        }
    }

    private void markOperationComplete(Long operationSequenceId) {
        Long heapSize = this.pendingOperationsWithSize.remove(operationSequenceId);
        if (heapSize != null) {
            this.currentWriteBufferSize -= heapSize.longValue();
        } else {
            LOG.warn("An operation completed successfully but provided multiple completion notifications. Please notify Google that this occurred.", new Object[0]);
        }
    }
}

