/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.grpc.async;

import com.google.bigtable.repackaged.com.google.cloud.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.AbstractRetryingRpcListener;
import com.google.bigtable.repackaged.com.google.cloud.grpc.async.BigtableAsyncRpc;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.StatusRuntimeException;
import java.util.concurrent.ScheduledExecutorService;

public class RetryingUnaryRpcListener<RequestT, ResponseT>
extends AbstractRetryingRpcListener<RequestT, ResponseT, ResponseT> {
    static final StatusRuntimeException NO_VALUE_SET_EXCEPTION = Status.INTERNAL.withDescription("No value received for unary call").asRuntimeException();
    private ResponseT value;

    public RetryingUnaryRpcListener(RetryOptions retryOptions, RequestT request, BigtableAsyncRpc<RequestT, ResponseT> retryableRpc, CallOptions callOptions, ScheduledExecutorService executorService, Metadata metadata) {
        super(retryOptions, request, retryableRpc, callOptions, executorService, metadata);
    }

    @Override
    public void onMessage(ResponseT message) {
        this.value = message;
        this.completionFuture.set(this.value);
    }

    @Override
    protected void onOK() {
        if (this.value == null) {
            this.completionFuture.setException(NO_VALUE_SET_EXCEPTION);
        }
    }
}

