/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.grpc.io;

import com.google.bigtable.repackaged.com.google.cloud.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.grpc.io.HeaderInterceptor;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptors;
import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ChannelPool
extends ManagedChannel {
    protected static final Logger LOG = new Logger(ChannelPool.class);
    private final AtomicReference<ImmutableList<ManagedChannel>> channels = new AtomicReference();
    private final AtomicInteger requestCount = new AtomicInteger();
    private final ImmutableList<HeaderInterceptor> headerInterceptors;
    private final ChannelFactory factory;
    private final String authority;
    private boolean shutdown = false;

    public ChannelPool(List<HeaderInterceptor> headerInterceptors, ChannelFactory factory) throws IOException {
        ManagedChannel channel = factory.create();
        this.channels.set(ImmutableList.of(channel));
        this.authority = channel.authority();
        this.factory = factory;
        this.headerInterceptors = headerInterceptors == null ? ImmutableList.of() : ImmutableList.copyOf(headerInterceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureChannelCount(int capacity) throws IOException {
        if (this.shutdown) {
            throw new IOException("The channel is closed.");
        }
        if (this.channels.get().size() < capacity) {
            ChannelPool channelPool = this;
            synchronized (channelPool) {
                if (this.channels.get().size() < capacity) {
                    ArrayList<ManagedChannel> newChannelList = new ArrayList<ManagedChannel>((Collection)this.channels.get());
                    while (newChannelList.size() < capacity) {
                        newChannelList.add(this.factory.create());
                    }
                    this.setChannels(newChannelList);
                }
            }
        }
    }

    private ManagedChannel getNextChannel() {
        int currentRequestNum = this.requestCount.getAndIncrement();
        ImmutableList<ManagedChannel> channelsList = this.channels.get();
        int index = Math.abs(currentRequestNum % channelsList.size());
        return (ManagedChannel)channelsList.get(index);
    }

    @Override
    public String authority() {
        return this.authority;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
        Preconditions.checkState(!this.shutdown, "Cannot perform operations on a closed connection");
        ClientCall<ReqT, RespT> delegate = this.getNextChannel().newCall(methodDescriptor, callOptions);
        return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(delegate){

            @Override
            protected void checkedStart(ClientCall.Listener<RespT> responseListener, Metadata headers) throws Exception {
                for (HeaderInterceptor interceptor : ChannelPool.this.headerInterceptors) {
                    interceptor.updateHeaders(headers);
                }
                this.delegate().start(responseListener, headers);
            }
        };
    }

    private void setChannels(List<ManagedChannel> newChannelList) {
        this.channels.set(ImmutableList.copyOf(newChannelList));
    }

    public int size() {
        return this.channels.get().size();
    }

    @Override
    public synchronized ManagedChannel shutdown() {
        for (ManagedChannel channel : this.channels.get()) {
            channel.shutdown();
        }
        this.shutdown = true;
        return this;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        for (ManagedChannel managedChannel : this.channels.get()) {
            if (managedChannel.isTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ManagedChannel shutdownNow() {
        for (ManagedChannel channel : this.channels.get()) {
            channel.shutdownNow();
        }
        return this;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long endTimeNanos = System.nanoTime() + unit.toNanos(timeout);
        for (ManagedChannel channel : this.channels.get()) {
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            if (awaitTimeNanos <= 0L) break;
            channel.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        return this.isTerminated();
    }

    public static interface ChannelFactory {
        public ManagedChannel create() throws IOException;
    }
}

