/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.grpc.scanner;

import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.ResultQueueEntry;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.ScanTimeoutException;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResponseQueueReader
implements StreamObserver<Row> {
    protected final BlockingQueue<ResultQueueEntry<Row>> resultQueue;
    protected AtomicBoolean completionMarkerFound = new AtomicBoolean(false);
    private final int readPartialRowTimeoutMillis;
    private boolean lastResponseProcessed = false;

    public ResponseQueueReader(int readPartialRowTimeoutMillis, int capacityCap) {
        this.resultQueue = new LinkedBlockingQueue<ResultQueueEntry<Row>>(capacityCap);
        this.readPartialRowTimeoutMillis = readPartialRowTimeoutMillis;
    }

    public synchronized Row getNextMergedRow() throws IOException {
        if (!this.lastResponseProcessed) {
            ResultQueueEntry<Row> queueEntry = this.getNext();
            if (queueEntry.isCompletionMarker()) {
                this.lastResponseProcessed = true;
            } else {
                return queueEntry.getResponseOrThrow();
            }
        }
        Preconditions.checkState(this.lastResponseProcessed, "Should only exit merge loop with by returning a complete Row or hitting end of stream.");
        return null;
    }

    protected ResultQueueEntry<Row> getNext() throws IOException {
        ResultQueueEntry<Row> queueEntry;
        try {
            queueEntry = this.resultQueue.poll(this.readPartialRowTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for next result", e);
        }
        if (queueEntry == null) {
            throw new ScanTimeoutException("Timeout while merging responses.");
        }
        return queueEntry;
    }

    public int available() {
        return this.resultQueue.size();
    }

    @Override
    public void onNext(Row row) {
        try {
            this.resultQueue.put(ResultQueueEntry.fromResponse(row));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while adding a ResultQueueEntry", e);
        }
    }

    @Override
    public void onError(Throwable t) {
        try {
            this.resultQueue.put(ResultQueueEntry.fromThrowable(t));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while adding a ResultQueueEntry", e);
        }
    }

    @Override
    public void onCompleted() {
        try {
            this.completionMarkerFound.set(true);
            this.resultQueue.put(ResultQueueEntry.completionMarker());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while adding a ResultQueueEntry", e);
        }
    }
}

