/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.grpc.scanner;

import com.google.bigtable.repackaged.com.google.api.client.util.BackOff;
import com.google.bigtable.repackaged.com.google.api.client.util.Sleeper;
import com.google.bigtable.repackaged.com.google.cloud.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.grpc.io.IOExceptionWithStatus;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.AbstractBigtableResultScanner;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.BigtableResultScannerFactory;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.BigtableRetriesExhaustedException;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.ResultScanner;
import com.google.bigtable.repackaged.com.google.cloud.grpc.scanner.ScanTimeoutException;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.RowRange;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.RowSet;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public class ResumingStreamingResultScanner
extends AbstractBigtableResultScanner {
    private static final Logger LOG = new Logger(ResumingStreamingResultScanner.class);
    private final BigtableResultScannerFactory<ReadRowsRequest, Row> scannerFactory;
    private final ReadRowsRequest originalRequest;
    private final RetryOptions retryOptions;
    private BackOff currentErrorBackoff;
    private ResultScanner<Row> currentDelegate;
    private Sleeper sleeper = Sleeper.DEFAULT;
    private long rowCount = 0L;
    private AtomicInteger timeoutRetryCount = new AtomicInteger();
    private final Logger logger;
    private ByteString lastFoundKey;

    public ResumingStreamingResultScanner(RetryOptions retryOptions, ReadRowsRequest originalRequest, BigtableResultScannerFactory<ReadRowsRequest, Row> scannerFactory) {
        this(retryOptions, originalRequest, scannerFactory, LOG);
    }

    @VisibleForTesting
    ResumingStreamingResultScanner(RetryOptions retryOptions, ReadRowsRequest originalRequest, BigtableResultScannerFactory<ReadRowsRequest, Row> scannerFactory, Logger logger) {
        this.originalRequest = originalRequest;
        this.scannerFactory = scannerFactory;
        this.currentDelegate = scannerFactory.createScanner(originalRequest);
        this.retryOptions = retryOptions;
        this.logger = logger;
    }

    @Override
    public Row next() throws IOException {
        while (true) {
            try {
                Row result = this.currentDelegate.next();
                if (result != null) {
                    this.updateLastFoundKey(result.getKey());
                    ++this.rowCount;
                    this.currentErrorBackoff = null;
                    this.timeoutRetryCount = null;
                }
                return result;
            }
            catch (ScanTimeoutException rte) {
                this.handleScanTimeout(rte);
                continue;
            }
            catch (IOExceptionWithStatus ioe) {
                this.handleIOException(ioe);
                continue;
            }
            break;
        }
    }

    @VisibleForTesting
    void updateLastFoundKey(ByteString key) {
        this.lastFoundKey = key;
    }

    private void handleScanTimeout(ScanTimeoutException rte) throws IOException {
        try {
            this.currentDelegate.close();
        }
        catch (IOException ioe) {
            this.logger.warn("Error closing scanner before reissuing request: ", ioe, new Object[0]);
        }
        this.logger.info("The client could not get a response in %d ms. Retrying the scan.", this.retryOptions.getReadPartialRowTimeoutMillis());
        if (this.timeoutRetryCount == null) {
            this.timeoutRetryCount = new AtomicInteger();
        }
        this.currentErrorBackoff = null;
        if (this.timeoutRetryCount.incrementAndGet() > this.retryOptions.getMaxScanTimeoutRetries()) {
            throw new BigtableRetriesExhaustedException("Exhausted streaming retries after too many timeouts", rte);
        }
        this.reissueRequest();
    }

    private void handleIOException(IOExceptionWithStatus ioe) throws IOException {
        long nextBackOffMillis;
        try {
            this.currentDelegate.close();
        }
        catch (IOException e) {
            this.logger.warn("Error closing scanner before reissuing request: ", e, new Object[0]);
        }
        Status.Code code = ioe.getStatus().getCode();
        if (this.retryOptions.isRetryable(code)) {
            this.logger.info("Reissuing scan after receiving error with status: %s.", ioe, code.name());
            if (this.currentErrorBackoff == null) {
                this.currentErrorBackoff = this.retryOptions.createBackoff();
            }
            if ((nextBackOffMillis = this.currentErrorBackoff.nextBackOffMillis()) == -1L) {
                throw new BigtableRetriesExhaustedException("Exhausted streaming retries.", ioe);
            }
        } else {
            throw ioe;
        }
        this.sleep(nextBackOffMillis);
        this.reissueRequest();
    }

    @Override
    public int available() {
        return this.currentDelegate.available();
    }

    @Override
    public void close() throws IOException {
        this.currentDelegate.close();
    }

    private void reissueRequest() {
        long numRowsLimit;
        ReadRowsRequest.Builder newRequest = ReadRowsRequest.newBuilder().setRows(this.filterRows()).setTableName(this.originalRequest.getTableName());
        if (this.originalRequest.hasFilter()) {
            newRequest.setFilter(this.originalRequest.getFilter());
        }
        if ((numRowsLimit = this.originalRequest.getRowsLimit()) > 0L) {
            Preconditions.checkArgument((numRowsLimit -= this.rowCount) > 0L, "The remaining number of rows must be greater than 0.");
            newRequest.setRowsLimit(numRowsLimit);
        }
        this.currentDelegate = this.scannerFactory.createScanner(newRequest.build());
    }

    @VisibleForTesting
    RowSet filterRows() {
        RowSet originalRows = this.originalRequest.getRows();
        if (this.lastFoundKey == null) {
            return originalRows;
        }
        RowSet.Builder rowSetBuilder = RowSet.newBuilder();
        ByteBuffer lastFoundKeyByteBuffer = this.lastFoundKey.asReadOnlyByteBuffer();
        for (ByteString key : originalRows.getRowKeysList()) {
            if (lastFoundKeyByteBuffer.compareTo(key.asReadOnlyByteBuffer()) >= 0) continue;
            rowSetBuilder.addRowKeys(key);
        }
        for (RowRange rowRange : originalRows.getRowRangesList()) {
            RowRange.EndKeyCase endKeyCase = rowRange.getEndKeyCase();
            if (endKeyCase == RowRange.EndKeyCase.END_KEY_CLOSED && this.endKeyIsAlreadyRead(lastFoundKeyByteBuffer, rowRange.getEndKeyClosed()) || endKeyCase == RowRange.EndKeyCase.END_KEY_OPEN && this.endKeyIsAlreadyRead(lastFoundKeyByteBuffer, rowRange.getEndKeyOpen())) continue;
            RowRange newRange = rowRange;
            RowRange.StartKeyCase startKeyCase = rowRange.getStartKeyCase();
            if (startKeyCase == RowRange.StartKeyCase.START_KEY_CLOSED && lastFoundKeyByteBuffer.compareTo(rowRange.getStartKeyClosed().asReadOnlyByteBuffer()) >= 0 || startKeyCase == RowRange.StartKeyCase.START_KEY_OPEN && lastFoundKeyByteBuffer.compareTo(rowRange.getStartKeyOpen().asReadOnlyByteBuffer()) > 0 || startKeyCase == RowRange.StartKeyCase.STARTKEY_NOT_SET) {
                newRange = rowRange.toBuilder().setStartKeyOpen(this.lastFoundKey).build();
            }
            rowSetBuilder.addRowRanges(newRange);
        }
        return rowSetBuilder.build();
    }

    private boolean endKeyIsAlreadyRead(ByteBuffer lastFoundKeyByteBuffer, ByteString endKey) {
        return !endKey.isEmpty() && lastFoundKeyByteBuffer.compareTo(endKey.asReadOnlyByteBuffer()) >= 0;
    }

    private void sleep(long millis) throws IOException {
        try {
            this.sleeper.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while sleeping for resume", e);
        }
    }
}

