/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.grpc.scanner;

import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Cell;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Column;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Family;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Row;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.BigtableZeroCopyByteStringUtil;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class RowMerger
implements StreamObserver<ReadRowsResponse> {
    private final StreamObserver<Row> observer;
    private RowMergerState state = RowMergerState.NewRow;
    private ByteString previousKey;
    private RowInProgress rowInProgress;
    private boolean complete;

    public static List<Row> toRows(Iterable<ReadRowsResponse> responses) {
        final ArrayList<Row> result = new ArrayList<Row>();
        RowMerger rowMerger = new RowMerger(new StreamObserver<Row>(){

            @Override
            public void onNext(Row value) {
                result.add(value);
            }

            @Override
            public void onError(Throwable t) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new IllegalStateException(t);
            }

            @Override
            public void onCompleted() {
            }
        });
        for (ReadRowsResponse response : responses) {
            rowMerger.onNext(response);
        }
        rowMerger.onCompleted();
        return result;
    }

    private static boolean isCommit(ReadRowsResponse.CellChunk chunk) {
        return chunk.getRowStatusCase() == ReadRowsResponse.CellChunk.RowStatusCase.COMMIT_ROW && chunk.getCommitRow();
    }

    private static boolean isReset(ReadRowsResponse.CellChunk chunk) {
        return chunk.getRowStatusCase() == ReadRowsResponse.CellChunk.RowStatusCase.RESET_ROW && chunk.getResetRow();
    }

    public RowMerger(StreamObserver<Row> observer) {
        this.observer = observer;
    }

    @Override
    public void onNext(ReadRowsResponse readRowsResponse) {
        if (this.complete) {
            this.onError(new IllegalStateException("Adding partialRow after completion"));
            return;
        }
        ByteString lastScannedRowKey = readRowsResponse.getLastScannedRowKey();
        if (!lastScannedRowKey.isEmpty()) {
            this.state.handleLastScannedRowKey(lastScannedRowKey);
        }
        for (ReadRowsResponse.CellChunk chunk : readRowsResponse.getChunksList()) {
            try {
                this.state.validateChunk(this.rowInProgress, this.previousKey, chunk);
            }
            catch (Exception e) {
                this.onError(e);
                return;
            }
            try {
                if (RowMerger.isReset(chunk)) {
                    this.rowInProgress = null;
                    this.state = RowMergerState.NewRow;
                    continue;
                }
                if (this.rowInProgress == null) {
                    this.rowInProgress = new RowInProgress();
                    this.rowInProgress.updateCurrentKey(chunk);
                }
                if (chunk.getValueSize() > 0) {
                    this.rowInProgress.addPartialCellChunk(chunk);
                    this.state = RowMergerState.CellInProgress;
                } else if (this.rowInProgress.hasChunkInProgess()) {
                    this.rowInProgress.addPartialCellChunk(chunk);
                    this.rowInProgress.completeMultiChunkCell();
                    this.state = RowMergerState.RowInProgress;
                } else {
                    this.rowInProgress.addFullChunk(chunk);
                    this.state = RowMergerState.RowInProgress;
                }
                if (!RowMerger.isCommit(chunk)) continue;
                this.observer.onNext(this.rowInProgress.createRow());
                this.previousKey = this.rowInProgress.getRowKey();
                this.rowInProgress = null;
                this.state = RowMergerState.NewRow;
            }
            catch (IOException e) {
                this.onError(e);
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        this.observer.onError(e);
        this.complete = true;
    }

    @Override
    public void onCompleted() {
        this.state.handleOnComplete(this.observer);
    }

    private static final class RowInProgress {
        private final FamilyBuilderManager families = new FamilyBuilderManager();
        private CellIdentifier currentId;
        private Cell.Builder cellBuilderInProgress;
        private ByteArrayOutputStream outputStream;

        private RowInProgress() {
        }

        void addFullChunk(ReadRowsResponse.CellChunk chunk) {
            Preconditions.checkState(!this.hasChunkInProgess());
            this.addCell(Cell.newBuilder().setTimestampMicros(chunk.getTimestampMicros()).addAllLabels(chunk.getLabelsList()).setValue(chunk.getValue()).build());
        }

        public void completeMultiChunkCell() {
            Preconditions.checkArgument(this.hasChunkInProgess());
            ByteString value = BigtableZeroCopyByteStringUtil.wrap(this.outputStream.toByteArray());
            this.addCell(this.cellBuilderInProgress.setValue(value).build());
            this.outputStream = null;
            this.cellBuilderInProgress = null;
        }

        private void addCell(Cell cell) {
            this.families.addCell(this.currentId.family, this.currentId.qualifier, cell);
        }

        void updateCurrentKey(ReadRowsResponse.CellChunk chunk) {
            this.currentId = this.currentId == null || this.isNewRowKey(chunk) ? new CellIdentifier(chunk) : (chunk.hasFamilyName() ? this.currentId.nextKeyForFamily(chunk) : (chunk.hasQualifier() ? this.currentId.nextKeyForQualifier(chunk) : this.currentId.nextKeyForTimestamp(chunk)));
        }

        private boolean isNewRowKey(ReadRowsResponse.CellChunk chunk) {
            ByteString rowKey = chunk.getRowKey();
            return !rowKey.isEmpty() && !rowKey.equals(this.currentId.rowKey);
        }

        public boolean hasChunkInProgess() {
            return this.outputStream != null;
        }

        void addPartialCellChunk(ReadRowsResponse.CellChunk chunk) throws IOException {
            if (this.outputStream == null) {
                this.outputStream = new ByteArrayOutputStream(chunk.getValueSize());
                this.cellBuilderInProgress = Cell.newBuilder().setTimestampMicros(chunk.getTimestampMicros()).addAllLabels(chunk.getLabelsList());
            }
            chunk.getValue().writeTo(this.outputStream);
        }

        public Row createRow() {
            Row.Builder rowBuilder = Row.newBuilder().setKey(this.getRowKey());
            this.families.addFamiliesTo(rowBuilder);
            return rowBuilder.build();
        }

        public ByteString getRowKey() {
            return this.currentId.rowKey;
        }
    }

    private static class CellIdentifier {
        final ByteString rowKey;
        final String family;
        final ByteString qualifier;
        final long timestampMicros;
        final List<String> labels;

        CellIdentifier(ReadRowsResponse.CellChunk chunk) {
            this(chunk.getRowKey(), chunk);
        }

        CellIdentifier(ByteString rowKey, ReadRowsResponse.CellChunk chunk) {
            this(rowKey, chunk.getFamilyName().getValue(), chunk);
        }

        CellIdentifier(ByteString rowKey, String family, ReadRowsResponse.CellChunk chunk) {
            this(rowKey, family, chunk.getQualifier().getValue(), chunk);
        }

        CellIdentifier(ByteString rowKey, String family, ByteString qualifier, ReadRowsResponse.CellChunk chunk) {
            this(rowKey, family, qualifier, chunk.getTimestampMicros(), chunk.getLabelsList());
        }

        CellIdentifier(ByteString rowKey, String family, ByteString qualifier, long timestampMicros, List<String> labels) {
            this.rowKey = rowKey;
            this.family = family;
            this.qualifier = qualifier;
            this.timestampMicros = timestampMicros;
            this.labels = labels;
        }

        CellIdentifier nextKeyForFamily(ReadRowsResponse.CellChunk chunk) {
            return new CellIdentifier(this.rowKey, chunk);
        }

        CellIdentifier nextKeyForQualifier(ReadRowsResponse.CellChunk chunk) {
            return new CellIdentifier(this.rowKey, this.family, chunk);
        }

        CellIdentifier nextKeyForTimestamp(ReadRowsResponse.CellChunk chunk) {
            return new CellIdentifier(this.rowKey, this.family, this.qualifier, chunk);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof CellIdentifier)) {
                return false;
            }
            CellIdentifier other = (CellIdentifier)obj;
            return Objects.equals(this.rowKey, other.rowKey) && Objects.equals(this.family, other.family) && Objects.equals(this.qualifier, other.qualifier) && this.timestampMicros == other.timestampMicros && Objects.equals(this.labels, other.labels);
        }

        public int hashCode() {
            return Objects.hash(this.rowKey, this.family, this.qualifier, this.timestampMicros, this.labels);
        }
    }

    private static class CellKey
    implements Comparable<CellKey> {
        final String family;
        final ByteString qualifier;

        CellKey(String family, ByteString qualifier) {
            this.family = family;
            this.qualifier = qualifier;
        }

        @Override
        public int compareTo(CellKey o) {
            int comp = this.family.compareTo(o.family);
            if (comp != 0) {
                return comp;
            }
            return this.qualifier.asReadOnlyByteBuffer().compareTo(o.qualifier.asReadOnlyByteBuffer());
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("family", this.family).add("qualifier", this.qualifier).toString();
        }
    }

    private static class FamilyBuilderManager {
        private final Map<CellKey, Column.Builder> columnBuilders = new TreeMap<CellKey, Column.Builder>();

        private FamilyBuilderManager() {
        }

        public void addCell(String family, ByteString qualifier, Cell cell) {
            CellKey key = new CellKey(family, qualifier);
            Column.Builder columnBuilder = this.columnBuilders.get(key);
            if (columnBuilder == null) {
                columnBuilder = Column.newBuilder().setQualifier(qualifier);
                this.columnBuilders.put(key, columnBuilder);
            }
            columnBuilder.addCells(cell);
        }

        public Row.Builder addFamiliesTo(Row.Builder rowBuilder) {
            CellKey previousKey = null;
            Family.Builder currentFamilyBuilder = null;
            for (Map.Entry<CellKey, Column.Builder> entry : this.columnBuilders.entrySet()) {
                CellKey currentKey = entry.getKey();
                if (previousKey == null || !previousKey.family.equals(currentKey.family)) {
                    currentFamilyBuilder = rowBuilder.addFamiliesBuilder().setName(currentKey.family);
                }
                currentFamilyBuilder.addColumns(entry.getValue());
                previousKey = currentKey;
            }
            return rowBuilder;
        }
    }

    private static enum RowMergerState {
        NewRow{

            @Override
            void handleLastScannedRowKey(ByteString lastScannedRowKey) {
                throw new IllegalStateException("Encountered a lastScannedRowKey while processing a row.");
            }

            @Override
            void validateChunk(RowInProgress rowInProgess, ByteString previousKey, ReadRowsResponse.CellChunk newChunk) {
                Preconditions.checkArgument(rowInProgess == null, "A new row cannot have existing state: %s", newChunk);
                Preconditions.checkArgument(newChunk.getRowStatusCase() != ReadRowsResponse.CellChunk.RowStatusCase.RESET_ROW, "A new row cannot be reset: %s", newChunk);
                Preconditions.checkArgument(newChunk.hasFamilyName(), "A family must be set: %s", newChunk);
                ByteString rowKey = newChunk.getRowKey();
                Preconditions.checkArgument(!rowKey.isEmpty(), "A row key must be set: %s", newChunk);
                Preconditions.checkState(previousKey == null || !rowKey.equals(previousKey), "A commit happened but the same key followed: %s", newChunk);
                Preconditions.checkArgument(newChunk.hasQualifier(), "A column qualifier must be set: %s", newChunk);
                if (newChunk.getValueSize() > 0) {
                    Preconditions.checkArgument(!RowMerger.isCommit(newChunk), "A row cannot be have a value size and be a commit row: %s", newChunk);
                }
            }

            @Override
            void handleOnComplete(StreamObserver<Row> observer) {
                observer.onCompleted();
            }
        }
        ,
        RowInProgress{

            @Override
            void handleLastScannedRowKey(ByteString lastScannedRowKey) {
                throw new IllegalStateException("Encountered a lastScannedRowKey while processing a row.");
            }

            @Override
            void validateChunk(RowInProgress rowInProgess, ByteString previousKey, ReadRowsResponse.CellChunk newChunk) {
                if (newChunk.hasFamilyName()) {
                    Preconditions.checkArgument(newChunk.hasQualifier(), "A qualifier must be specified: %s", newChunk);
                }
                ByteString newRowKey = newChunk.getRowKey();
                if (RowMerger.isReset(newChunk)) {
                    Preconditions.checkState(newRowKey.isEmpty() && !newChunk.hasFamilyName() && !newChunk.hasQualifier() && newChunk.getValue().isEmpty() && newChunk.getTimestampMicros() == 0L, "A reset should have no data");
                } else {
                    Preconditions.checkState(newRowKey.isEmpty() || newRowKey.equals(rowInProgess.getRowKey()), "A commit is required between row keys: %s", newChunk);
                    rowInProgess.updateCurrentKey(newChunk);
                    Preconditions.checkArgument(newChunk.getValueSize() == 0 || !RowMerger.isCommit(newChunk), "A row cannot be have a value size and be a commit row: %s", newChunk);
                }
            }

            @Override
            void handleOnComplete(StreamObserver<Row> observer) {
                observer.onError(new IllegalStateException("Got a partial row, but the stream ended"));
            }
        }
        ,
        CellInProgress{

            @Override
            void handleLastScannedRowKey(ByteString lastScannedRowKey) {
                throw new IllegalStateException("Encountered a lastScannedRowKey while processing a cell.");
            }

            @Override
            void validateChunk(RowInProgress rowInProgess, ByteString previousKey, ReadRowsResponse.CellChunk newChunk) {
                if (RowMerger.isReset(newChunk)) {
                    Preconditions.checkState(newChunk.getRowKey().isEmpty() && !newChunk.hasFamilyName() && !newChunk.hasQualifier() && newChunk.getValue().isEmpty() && newChunk.getTimestampMicros() == 0L, "A reset should have no data");
                } else {
                    Preconditions.checkArgument(newChunk.getValueSize() == 0 || !RowMerger.isCommit(newChunk), "A row cannot be have a value size and be a commit row: %s", newChunk);
                }
            }

            @Override
            void handleOnComplete(StreamObserver<Row> observer) {
                observer.onError(new IllegalStateException("Got a partial row, but the stream ended"));
            }
        };


        abstract void handleLastScannedRowKey(ByteString var1);

        abstract void validateChunk(RowInProgress var1, ByteString var2, ReadRowsResponse.CellChunk var3) throws Exception;

        abstract void handleOnComplete(StreamObserver<Row> var1);
    }
}

