/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters;

import com.google.bigtable.repackaged.com.google.cloud.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.AppendAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.DeleteAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.IncrementAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.MutationAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.PutAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.UnsupportedOperationAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.BigtableWhileMatchResultScannerAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.filters.FilterAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.BigtableResultScannerAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.GetAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.RowAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.ScanAdapter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Increment;

public final class Adapters {
    public static final RowAdapter ROW_ADAPTER = new RowAdapter();
    public static final AppendAdapter APPEND_ADAPTER = new AppendAdapter();
    public static final IncrementAdapter INCREMENT_ADAPTER = new IncrementAdapter();
    public static final DeleteAdapter DELETE_ADAPTER = new DeleteAdapter();
    public static final FilterAdapter FILTER_ADAPTER = FilterAdapter.buildAdapter();
    public static final ScanAdapter SCAN_ADAPTER = new ScanAdapter(FILTER_ADAPTER);
    public static final BigtableResultScannerAdapter BIGTABLE_RESULT_SCAN_ADAPTER = new BigtableResultScannerAdapter(ROW_ADAPTER);
    public static final BigtableWhileMatchResultScannerAdapter BIGTABLE_WHILE_MATCH_RESULT_RESULT_SCAN_ADAPTER = new BigtableWhileMatchResultScannerAdapter(ROW_ADAPTER);
    public static final GetAdapter GET_ADAPTER = new GetAdapter(SCAN_ADAPTER);

    public static MutationAdapter createMutationsAdapter(PutAdapter putAdapter) {
        return new MutationAdapter(DELETE_ADAPTER, putAdapter, new UnsupportedOperationAdapter<Increment>("increment"), new UnsupportedOperationAdapter<Append>("append"));
    }

    public static PutAdapter createPutAdapter(Configuration config, BigtableOptions options) {
        boolean setClientTimestamp = !options.getRetryOptions().allowRetriesWithoutTimestamp();
        return new PutAdapter(config.getInt("hbase.client.keyvalue.maxsize", -1), setClientTimestamp);
    }

    private Adapters() {
    }
}

