/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.CellDeduplicationHelper;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.OperationAdapter;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadModifyWriteRule;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.Bytes;

public class AppendAdapter
implements OperationAdapter<Append, ReadModifyWriteRowRequest.Builder> {
    @Override
    public ReadModifyWriteRowRequest.Builder adapt(Append operation) {
        ReadModifyWriteRowRequest.Builder result = ReadModifyWriteRowRequest.newBuilder();
        result.setRowKey(ByteString.copyFrom(operation.getRow()));
        for (Map.Entry entry : operation.getFamilyCellMap().entrySet()) {
            String familyName = Bytes.toString((byte[])((byte[])entry.getKey()));
            List<Cell> cells = CellDeduplicationHelper.deduplicateFamily((Mutation)operation, (byte[])entry.getKey());
            for (Cell cell : cells) {
                ReadModifyWriteRule.Builder rule = result.addRulesBuilder();
                rule.setFamilyName(familyName);
                rule.setColumnQualifier(ByteString.copyFrom(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
                rule.setAppendValue(ByteString.copyFrom(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
            }
        }
        return result;
    }
}

