/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Mutation;

public class CellDeduplicationHelper {
    public static List<Cell> deduplicateFamily(Mutation mutation, byte[] family) {
        LinkedList<Cell> result = new LinkedList<Cell>();
        HashMap<QualifierOnlyKey, Cell> latestCells = new HashMap<QualifierOnlyKey, Cell>();
        List familyCells = (List)mutation.getFamilyCellMap().get(family);
        if (familyCells == null || family.length == 0) {
            return new LinkedList<Cell>();
        }
        for (Cell cell : familyCells) {
            QualifierOnlyKey key = new QualifierOnlyKey(CellUtil.cloneQualifier((Cell)cell));
            latestCells.put(key, cell);
        }
        result.addAll(latestCells.values());
        return result;
    }

    protected static class QualifierOnlyKey {
        final byte[] qualifier;

        public QualifierOnlyKey(byte[] qualifier) {
            this.qualifier = qualifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QualifierOnlyKey that = (QualifierOnlyKey)o;
            return Arrays.equals(this.qualifier, that.qualifier);
        }

        public int hashCode() {
            return Arrays.hashCode(this.qualifier);
        }
    }
}

