/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.OperationAdapter;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.Mutation;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.TimestampRange;
import com.google.bigtable.repackaged.com.google.protobuf.BigtableZeroCopyByteStringUtil;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.BigtableConstants;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;

public class DeleteAdapter
implements OperationAdapter<Delete, MutateRowRequest.Builder> {
    static boolean isPointDelete(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.Delete.getCode();
    }

    static boolean isColumnDelete(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteColumn.getCode();
    }

    static boolean isFamilyDelete(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteFamily.getCode();
    }

    static boolean isFamilyVersionDelete(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteFamilyVersion.getCode();
    }

    static void throwOnUnsupportedCellType(Cell cell) {
        throw new UnsupportedOperationException(String.format("Cell type %s is unsupported.", cell.getTypeByte()));
    }

    static void throwOnUnsupportedDeleteFamilyVersion(Cell cell) {
        throw new UnsupportedOperationException("Cannot perform column family deletion at timestamp.");
    }

    static void throwIfUnsupportedDeleteFamily(Cell cell) {
        if (cell.getTimestamp() != Long.MAX_VALUE) {
            throw new UnsupportedOperationException("Cannot perform column family deletion before timestamp.");
        }
    }

    static void throwIfUnsupportedDeleteRow(Delete operation) {
        if (operation.getTimeStamp() != Long.MAX_VALUE) {
            throw new UnsupportedOperationException("Cannot perform row deletion at timestamp.");
        }
    }

    static void throwIfUnsupportedPointDelete(Cell cell) {
        if (cell.getTimestamp() == Long.MAX_VALUE) {
            throw new UnsupportedOperationException("Cannot delete single latest cell.");
        }
    }

    static Mutation.DeleteFromColumn.Builder addDeleteFromColumnMods(MutateRowRequest.Builder result, ByteString familyByteString, Cell cell) {
        ByteString cellQualifierByteString = ByteString.copyFrom(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        Mutation.DeleteFromColumn.Builder deleteBuilder = result.addMutationsBuilder().getDeleteFromColumnBuilder().setFamilyNameBytes(familyByteString).setColumnQualifier(cellQualifierByteString);
        long endTimestamp = BigtableConstants.BIGTABLE_TIMEUNIT.convert(cell.getTimestamp() + 1L, BigtableConstants.HBASE_TIMEUNIT);
        if (DeleteAdapter.isPointDelete(cell)) {
            long startTimestamp = BigtableConstants.BIGTABLE_TIMEUNIT.convert(cell.getTimestamp(), BigtableConstants.HBASE_TIMEUNIT);
            deleteBuilder.getTimeRangeBuilder().setStartTimestampMicros(startTimestamp).setEndTimestampMicros(endTimestamp);
        } else if (cell.getTimestamp() != Long.MAX_VALUE) {
            deleteBuilder.getTimeRangeBuilder().setEndTimestampMicros(endTimestamp);
        }
        return deleteBuilder;
    }

    @Override
    public MutateRowRequest.Builder adapt(Delete operation) {
        MutateRowRequest.Builder result = MutateRowRequest.newBuilder().setRowKey(ByteString.copyFrom(operation.getRow()));
        if (operation.getFamilyCellMap().isEmpty()) {
            DeleteAdapter.throwIfUnsupportedDeleteRow(operation);
            result.addMutationsBuilder().setDeleteFromRow(Mutation.DeleteFromRow.getDefaultInstance());
        } else {
            for (Map.Entry entry : operation.getFamilyCellMap().entrySet()) {
                ByteString familyByteString = ByteString.copyFrom((byte[])entry.getKey());
                for (Cell cell : (List)entry.getValue()) {
                    if (DeleteAdapter.isColumnDelete(cell) || DeleteAdapter.isPointDelete(cell)) {
                        if (DeleteAdapter.isPointDelete(cell)) {
                            DeleteAdapter.throwIfUnsupportedPointDelete(cell);
                        }
                        DeleteAdapter.addDeleteFromColumnMods(result, familyByteString, cell);
                        continue;
                    }
                    if (DeleteAdapter.isFamilyDelete(cell)) {
                        DeleteAdapter.throwIfUnsupportedDeleteFamily(cell);
                        result.addMutationsBuilder().getDeleteFromFamilyBuilder().setFamilyNameBytes(familyByteString);
                        continue;
                    }
                    if (DeleteAdapter.isFamilyVersionDelete(cell)) {
                        DeleteAdapter.throwOnUnsupportedDeleteFamilyVersion(cell);
                        continue;
                    }
                    DeleteAdapter.throwOnUnsupportedCellType(cell);
                }
            }
        }
        return result;
    }

    @Override
    public Delete adapt(MutateRowRequest request) {
        Delete delete = new Delete(request.getRowKey().toByteArray());
        boolean isDeleteRow = false;
        block5: for (Mutation mutation : request.getMutationsList()) {
            switch (mutation.getMutationCase()) {
                case DELETE_FROM_COLUMN: {
                    long timestamp;
                    Mutation.DeleteFromColumn deleteFromColumn = mutation.getDeleteFromColumn();
                    TimestampRange timeRange = deleteFromColumn.getTimeRange();
                    if (timeRange.getStartTimestampMicros() == 0L) {
                        timestamp = BigtableConstants.HBASE_TIMEUNIT.convert(timeRange.getEndTimestampMicros(), BigtableConstants.BIGTABLE_TIMEUNIT) - 1L;
                        delete.addColumns(DeleteAdapter.getBytes(deleteFromColumn.getFamilyNameBytes()), DeleteAdapter.getBytes(deleteFromColumn.getColumnQualifier()), timestamp);
                        continue block5;
                    }
                    timestamp = BigtableConstants.HBASE_TIMEUNIT.convert(timeRange.getStartTimestampMicros(), BigtableConstants.BIGTABLE_TIMEUNIT);
                    delete.addColumn(DeleteAdapter.getBytes(deleteFromColumn.getFamilyNameBytes()), DeleteAdapter.getBytes(deleteFromColumn.getColumnQualifier()), timestamp);
                    continue block5;
                }
                case DELETE_FROM_FAMILY: {
                    delete.addFamily(DeleteAdapter.getBytes(mutation.getDeleteFromFamily().getFamilyNameBytes()));
                    continue block5;
                }
                case DELETE_FROM_ROW: {
                    isDeleteRow = true;
                    continue block5;
                }
            }
            throw new IllegalArgumentException("DeleteAdapter does not support " + mutation.getMutationCase() + ".");
        }
        if (isDeleteRow && !delete.getFamilyCellMap().isEmpty()) {
            throw new IllegalArgumentException("DeleteAdapter does not support DELETE_FROM_ROW with other operations.");
        }
        return delete;
    }

    private static byte[] getBytes(ByteString bs) {
        return BigtableZeroCopyByteStringUtil.zeroCopyGetBytes(bs);
    }
}

