/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters;

import com.google.bigtable.repackaged.com.google.cloud.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.grpc.BigtableTableName;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.Adapters;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.MutationAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.PutAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.RowMutationsAdapter;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.DefaultReadHooks;
import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.read.ReadHooks;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.ReadRowsRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;

public class HBaseRequestAdapter {
    protected final MutationAdapters mutationAdapters;
    protected final TableName tableName;
    protected final BigtableTableName bigtableTableName;

    public HBaseRequestAdapter(BigtableOptions options, TableName tableName, Configuration config) {
        this(options, tableName, new MutationAdapters(options, config));
    }

    public HBaseRequestAdapter(BigtableOptions options, TableName tableName, MutationAdapters mutationAdapters) {
        this.tableName = tableName;
        this.bigtableTableName = options.getInstanceName().toTableName(tableName.getQualifierAsString());
        this.mutationAdapters = mutationAdapters;
    }

    public MutateRowRequest adapt(Delete delete) {
        MutateRowRequest.Builder requestBuilder = Adapters.DELETE_ADAPTER.adapt(delete);
        requestBuilder.setTableName(this.getTableNameString());
        return requestBuilder.build();
    }

    public ReadRowsRequest adapt(Get get) {
        DefaultReadHooks readHooks = new DefaultReadHooks();
        ReadRowsRequest.Builder builder = Adapters.GET_ADAPTER.adapt(get, (ReadHooks)readHooks);
        builder.setTableName(this.getTableNameString());
        return readHooks.applyPreSendHook(builder.build());
    }

    public ReadRowsRequest adapt(Scan scan) {
        DefaultReadHooks readHooks = new DefaultReadHooks();
        ReadRowsRequest.Builder builder = Adapters.SCAN_ADAPTER.adapt(scan, (ReadHooks)readHooks);
        builder.setTableName(this.getTableNameString());
        return readHooks.applyPreSendHook(builder.build());
    }

    public ReadModifyWriteRowRequest adapt(Append append) {
        ReadModifyWriteRowRequest.Builder builder = Adapters.APPEND_ADAPTER.adapt(append);
        builder.setTableName(this.getTableNameString());
        return builder.build();
    }

    public ReadModifyWriteRowRequest adapt(Increment increment) {
        ReadModifyWriteRowRequest.Builder builder = Adapters.INCREMENT_ADAPTER.adapt(increment);
        builder.setTableName(this.getTableNameString());
        return builder.build();
    }

    public MutateRowRequest adapt(Put put) {
        MutateRowRequest.Builder builder = this.mutationAdapters.putAdapter.adapt(put);
        builder.setTableName(this.getTableNameString());
        return builder.build();
    }

    public MutateRowRequest adapt(RowMutations mutations) {
        MutateRowRequest.Builder builder = this.mutationAdapters.rowMutationsAdapter.adapt(mutations);
        builder.setTableName(this.getTableNameString());
        return builder.build();
    }

    public MutateRowRequest adapt(Mutation mutation) {
        MutateRowRequest.Builder builder = this.mutationAdapters.mutationAdapter.adapt(mutation);
        builder.setTableName(this.getTableNameString());
        return builder.build();
    }

    public BigtableTableName getBigtableTableName() {
        return this.bigtableTableName;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    protected String getTableNameString() {
        return this.getBigtableTableName().toString();
    }

    public static class MutationAdapters {
        protected final PutAdapter putAdapter;
        protected final MutationAdapter mutationAdapter;
        protected final RowMutationsAdapter rowMutationsAdapter;

        public MutationAdapters(BigtableOptions options, Configuration config) {
            this.putAdapter = Adapters.createPutAdapter(config, options);
            this.mutationAdapter = Adapters.createMutationsAdapter(this.putAdapter);
            this.rowMutationsAdapter = new RowMutationsAdapter(this.mutationAdapter);
        }
    }
}

