/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.hbase.adapters;

import com.google.bigtable.repackaged.com.google.cloud.hbase.adapters.OperationAdapter;
import com.google.bigtable.repackaged.com.google.com.google.bigtable.v2.MutateRowRequest;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;

public class MutationAdapter
implements OperationAdapter<Mutation, MutateRowRequest.Builder> {
    private final AdapterInstanceMap adapterMap = new AdapterInstanceMap();

    public MutationAdapter(OperationAdapter<Delete, MutateRowRequest.Builder> deleteAdapter, OperationAdapter<Put, MutateRowRequest.Builder> putAdapter, OperationAdapter<Increment, MutateRowRequest.Builder> incrementAdapter, OperationAdapter<Append, MutateRowRequest.Builder> appendAdapter) {
        this.adapterMap.put(Delete.class, deleteAdapter);
        this.adapterMap.put(Put.class, putAdapter);
        this.adapterMap.put(Increment.class, incrementAdapter);
        this.adapterMap.put(Append.class, appendAdapter);
    }

    @Override
    public MutateRowRequest.Builder adapt(Mutation mutation) {
        Object adapter = this.adapterMap.get(mutation.getClass());
        if (adapter == null) {
            throw new UnsupportedOperationException(String.format("Cannot adapt mutation of type %s.", mutation.getClass().getCanonicalName()));
        }
        return (MutateRowRequest.Builder)adapter.adapt((Mutation)mutation);
    }

    static class AdapterInstanceMap {
        private Map<Class<?>, OperationAdapter<?, ?>> unsafeMap = new HashMap();

        AdapterInstanceMap() {
        }

        public <S extends Mutation, U extends OperationAdapter<S, MutateRowRequest.Builder>> Class<S> put(Class<S> key, U adapter) {
            this.unsafeMap.put(key, adapter);
            return key;
        }

        public <S extends Mutation, U extends OperationAdapter<S, MutateRowRequest.Builder>> U get(Class<? extends S> key) {
            return (U)this.unsafeMap.get(key);
        }
    }
}

